## TSS centred strand-specific coverage profiles around the TSS (+/- 1kb) of mouse genes created using DeepTools v3.5.1.
## Transcript TSS were defined as the protein-coding transcript subset from standard chromosomes (1-19, X, Y) of Ensembl GRCm38.89
## The input for the analysis was TPM normalised read depth coverage files (bigwig), split by alignment strand.

ml deepTools/3.5.1-foss-2021b;  

computeMatrix reference-point --referencePoint TSS -S CAGE_D1_ESC_R1_fwd.threshold.tpm.bw CAGE_D1_ESC_R2_fwd.threshold.tpm.bw CAGE_D2_ESC_R1_fwd.threshold.tpm.bw CAGE_D2_ESC_R2_fwd.threshold.tpm.bw polyA_TSS_R1_fwd.threshold.tpm.bw polyA_TSS_R2_fwd.threshold.tpm.bw --samplesLabel CAGE_D1_ESC_R1 CAGE_D1_ESC_R2 CAGE_D2_ESC_R1 CAGE_D2_ESC_R2 polyA_TSS_R1 polyA_TSS_R2 --missingDataAsZero --skipZeros --averageTypeBins mean  -R data/mm10_transcripts_protein_coding.fwd.bed -a 1000 -b 1000 --binSize 10 -p 8 -o matrix.bigwig_fwd.feat_fwd.gz 


computeMatrix reference-point --referencePoint TSS -S CAGE_D1_ESC_R1_rev.threshold.tpm.bw CAGE_D1_ESC_R2_rev.threshold.tpm.bw CAGE_D2_ESC_R1_rev.threshold.tpm.bw CAGE_D2_ESC_R2_rev.threshold.tpm.bw polyA_TSS_R1_rev.threshold.tpm.bw polyA_TSS_R2_rev.threshold.tpm.bw --samplesLabel CAGE_D1_ESC_R1 CAGE_D1_ESC_R2 CAGE_D2_ESC_R1 CAGE_D2_ESC_R2 polyA_TSS_R1 polyA_TSS_R2 --missingDataAsZero --skipZeros --averageTypeBins mean  -R data/mm10_transcripts_protein_coding.rev.bed -a 1000 -b 1000 --binSize 10 -p 8 -o matrix.bigwig_rev.feat_rev.gz 

computeMatrixOperations rbind -m TSS/matrix.bigwig_fwd.feat_fwd.gz TSS/matrix.bigwig_rev.feat_rev.gz -o threshold_TPM/TSS/matrix.sense.gz 

plotHeatmap -m matrix.sense.gz -o eatmap.sense.pdf  --colorMap 'inferno' --missingDataColor 'black' --whatToShow 'plot, heatmap and colorbar' --heatmapWidth 12 --refPointLabel 'TSS' --averageTypeSummaryPlot 'mean' -x 'Centred distance (bp)' 
