## TSS centred strand-specific coverage profiles around the TSS (+/- 1kb) of yeast genes created using DeepTools v3.5.1.
## TSS were defined by iyer_tss.merged.sorted.bed (Saccharomyces_cerevisiae.R64-1-1), split by strand.
## The input for the analysis was genome-wide 5’-most nucleotide (tag) read depth coverage files (bigwig), split by alignment strand.


ml deepTools/3.5.1-foss-2021b;  

computeMatrix reference-point --referencePoint TSS -S original_fwd.bw optimized_fwd.bw --samplesLabel original optimized --missingDataAsZero --skipZeros --averageTypeBins mean  -R iyer_tss.merged.sorted.fwd.bed -a 1000 -b 1000 --binSize 10 -p 8 -o matrix.bigwig_fwd.feat_fwd.gz 

computeMatrix reference-point --referencePoint TSS -S optimized_rev.bw --samplesLabel original optimized --missingDataAsZero --skipZeros --averageTypeBins mean  -R yer_tss.merged.sorted.rev.bed -a 1000 -b 1000 --binSize 10 -p 8 -o matrix.bigwig_rev.feat_rev.gz 

computeMatrixOperations rbind -m matrix.bigwig_fwd.feat_fwd.gz matrix.bigwig_rev.feat_rev.gz -o  matrix.sense.gz 

plotHeatmap -m matrix.sense.gz -o heatmap.sense.pdf  --colorMap 'inferno' --missingDataColor 'black' --whatToShow 'plot, heatmap and colorbar' --heatmapWidth 12 --refPointLabel 'TSS' --averageTypeSummaryPlot 'mean' -x 'Centred distance (bp)' 


