#!/usr/bin/env python
#-*- coding: utf-8 -*-
from Bio import SeqIO
from Bio.Seq import Seq
from Bio.SeqRecord import SeqRecord
from Bio.Alphabet import IUPAC
import os.path
import glob



conca_cds=[]
for file_sp in glob.glob("*.cds") :  #tout recupere ensemble
	records = SeqIO.parse(file_sp, "fasta")
	dict_seq=SeqIO.to_dict(records)
	for key in dict_seq.keys():
		#newkey=key.split(".p")[0]
		#dict_seq[newkey] = dict_seq.pop(key)
		os.path.basename(file_sp)
		nom_sp=os.path.basename(file_sp).split(".")[0]
		initial=nom_sp.split('_')
		initial="".join([mot[:2].upper() for mot in initial])

	for contig_name in dict_seq.keys():
		name=initial+"_"+contig_name
		seq=dict_seq[contig_name].seq
		record = SeqRecord(seq,id=name,description=nom_sp)
		conca_cds.append(record)
SeqIO.write(conca_cds, "conca_cds.fa", "fasta")
