#! /usr/bin/python

import sys
from Bio import SeqIO
from Bio.Seq import Seq
from Bio.SeqRecord import SeqRecord
from collections import defaultdict

in_fasta=sys.argv[1]
out_fasta=sys.argv[2]

dedup_records = defaultdict(list)
for record in SeqIO.parse(in_fasta, "fasta"):
    # Use the sequence as the key and then have a list of id's as the value
    print(record.id)
    dedup_records[str(record.seq)].append(record.id)

# this creates a generator; if you need a physical list, replace the outer "(", ")" by "[" and "]", respectively
final_seq = (SeqRecord(Seq(seqi), id=gi[0], name='', description='') for seqi, gi in dedup_records.items())

# write file
SeqIO.write(final_seq, out_fasta, 'fasta')

with open("list_cds.txt","w") as f:
    print(dedup_records.values())
    f.write("\n".join([ x[0] for x in dedup_records.values() ]))
    f.write("\n")
