#!/usr/bin/env python


import glob
from Bio import AlignIO
from Bio.Align import MultipleSeqAlignment
import sys 

#4arg before after out and proportion  

fasta_before=sys.argv[1]
fasta_after=sys.argv[2]
fasta_out=sys.argv[3]
prop_keep=float(sys.argv[4])


len_before={}
for record in AlignIO.read( fasta_before, "fasta"):
	len_tot=len(str(record.seq))
	len_tiret=str(record.seq).count('-')
	len_pas_tiret=len_tot-len_tiret
	len_before[record.description]=len_pas_tiret

seq_keep=[]
for record in AlignIO.read( fasta_after , "fasta"):
	len_tot=len(str(record.seq))
	len_tiret=str(record.seq).count('-')
	len_pas_tiret=len_tot-len_tiret
	if len_pas_tiret > (len_before[record.description]*prop_keep):
		seq_keep.append(record)
	else:
		print("%s %s %s %s %s" %(record.description,len_pas_tiret > (len_before[record.description]*prop_keep),float(len_pas_tiret)/len_before[record.description],len_pas_tiret,len_before[record.description]))

if seq_keep:
	#faire un arg pour donner nom seq a la sortit 
	AlignIO.write(MultipleSeqAlignment(seq_keep), fasta_out, "fasta")
else:
	sys.exit(2)
