library(ggplot2)
library(ggtree)
library(ape)
library(phytools)


# this file contains the environments for all species 
envir = read.table(file = "df_taxonomy_and_env_gbif_species_Fabre_with_flagged_suspicious_coor.tsv", sep = "\t", header = TRUE, row.names = 1)  
envir$species=row.names(envir)


#  this files contains the full tree from Fabre et al with 2260 species
mytree<-read.tree("RODENTIA_MCC_WR05.tre")
length(mytree$tip.label)

mytree$tip.label=gsub("Cryptomys","Fukomys",mytree$tip.label)
mytree$tip.label=gsub("micklemi","darlingi",mytree$tip.label)

# We recode the species environmnents. the columns 'Bio17.without' excludes zoo and lab animals.
envir$env_2cat = "mesic"
envir$env_2cat[envir$Bio17.without<=40] = "xeric"

## We recontruct ancestral states on the tree from fabre et al, but we need first to select species for which we have environment data.
envir$species=gsub("Cryptomys","Fukomys",envir$species)
x=envir$env_2cat
names(x)=as.character(envir$species)
x=na.omit(x)
length(x)
xx=x[names(x)%in%mytree$tip.label]
mytree2=keep.tip(mytree, names(xx))

# Branches with null length need to be set to a small number
mytree3=multi2di(mytree2,tol = 1e-08)
mytree3$edge.length[mytree3$edge.length==0]=1e-08


# reconstruct ancestral states for a discrete character
fitER<-ace(xx,mytree3,model="ER",type="discrete")

## Plot the full phylogeny with ancestral states (Supplemental Data) 
cols=c("darkgreen","orange")
names(cols)=c("mesic","arid")
pdf("tree_anc_reconstruc_2cat_total.pdf",width=5,height=200)
plotTree(mytree3,fsize=0.5,ftype="i")
nodelabels(node=1:mytree3$Nnode+Ntip(mytree3),
           pie=fitER$lik.anc,piecol=cols,cex=0.5)
tiplabels(pie=to.matrix(x,sort(unique(x)))[mytree3$tip.label,],piecol=cols,cex=0.3)
add.simmap.legend(colors=cols,prompt=FALSE,x=0.9*par()$usr[1],
                  y=-max(nodeHeights(mytree2)),fsize=0.8)
dev.off()


## Plot the tree with the species used in paper
# to match species between dataset (changes in names, subspecies, synonyms, typos etc)

#  this files contains the tree for the Total_seq data used in the paper (made with phylogenomics)
tree_total=read.tree("local_online_species_tree_rep_8_20200605.raxml.bestTree")
# This species was malannoted in the initial paper
tree_total=drop.tip(tree_total,tip=c( "Peromyscus_leucopus"))

tip=tree_total$tip.label
tip=gsub("mechowii","mechowi",tip)
tip=gsub("Heterocephalus_glaber_male","Heterocephalus_glaber",tip)
tip=gsub("Dipodomys_spectabilis2","Dipodomys_spectabilis",tip)
tip=gsub("Marmota_marmota_marmota","Marmota_marmota",tip)
tip=gsub("Cricetulus_griseus_crigri","Cricetulus_griseus",tip)
tip=gsub("Peromyscus_maniculatus_bairdii","Peromyscus_maniculatus",tip)
tip=gsub("Arvicanthis_niloticus_sen","Arvicanthis_niloticus",tip)
tip=gsub("Fukomys_mechowi","Fukomys_mechowii",tip)
tip=tip[!tip%in%c("Nannomys_cot","Mus_musculus_ddo","Mus_musculus_wla","Arvicanthis_niloticus_lmo")]
tip=gsub("Mastomys_kollmanspergeri","Mastomys_kollmannspergeri",tip)
tip=gsub("Fukomys_micklemi","Fukomys_anselli",tip)
tip=gsub("Fukomys_mechowii","Fukomys_mechowi",tip)
tip=gsub("Nannospalax_galili","Spalax_ehrenbergi",tip)
tip=gsub("Nannomys_indutus","Mus_indutus",tip)#
tip=gsub("Cricetulus_griseus","Cricetulus_barabensis",tip)
tip=gsub("Ictidomys_tridecemlineatus","Spermophilus_tridecemlineatus",tip)
tip=gsub("Urocitellus_parryii","Spermophilus_parryii",tip) #

#tip=gsub("_"," ",tip)

envirt$species[!envirt$species%in%tip]

#mytree3$tip.label=gsub("Fukomys","Cryptomys",mytree3$tip.label)
#tip=gsub(" ","_",tip)
#tip=gsub("Fukomys","Cryptomys",tip)
mytree4=keep.tip(mytree3, tip)

# Get values on internal nodes of the full stree (Fabre et al) to report them on smaller tree (total_seq)
node=1:mytree4$Nnode+Ntip(mytree4)
d=sapply(node,function(n){
  c=extract.clade(mytree4, n)
  l=c$tip.label
  m=getMRCA(mytree3, l)-Ntip(mytree3)
  val=fitER$lik.anc[m,]
  return(val)
})

valanc=data.frame(t(d))
row.names(valanc)=node

ancStates=apply(valanc,1,function(x){names(sort(x))[4]})
names(ancStates)=node
mytree4 <- makeNodeLabel(mytree4, "n", prefix = paste(ancStates," "))

cols=c("darkgreen","orange")
names(cols)=c("mesic","arid")

envirt$env_2cat = "mesic"
envirt$env_2cat[envirt$Bio17.without<=40] = "xeric"
x=envirt$env_2cat
names(x)=as.character(envirt$Fabre_leaf_name)
x=na.omit(x)
length(x)

# Plot tree with ancestral stages on total_seq data for the supplemental Figure

pdf("tree_anc_reconstruc_2cat_fullname.pdf")
plotTree(mytree4,fsize=0.8,ftype="i")
nodelabels(node=1:mytree4$Nnode+Ntip(mytree4),
           pie=as.matrix(valanc),piecol=cols,cex=0.5)
tiplabels(pie=to.matrix(xx,sort(unique(xx)))[mytree4$tip.label,],piecol=cols,cex=0.3)
add.simmap.legend(colors=cols,prompt=FALSE,x=0.9*par()$usr[1],
                  y=-max(nodeHeights(mytree2)),fsize=0.8)
dev.off()

tree_total1=drop.tip(tree_total,tip=c( "Mus_musculus_ddo","Mus_musculus_wla","Nannomys_cot","Arvicanthis_niloticus_lmo"))
mytree5=keep.tip(mytree3, tip)

## make association between species

x=match(mytree5$tip.label,tree_total1$tip.label)
x[1]=44
x[3]=45
x[4]=46
x[6]=7
x[7]=6
x[9]=8
x[18]=10
x[21]=37
x[23]=43
x[29]=19
x[36]=28
x[39]=32    
x[46]=15 


association <- cbind(mytree5$tip.label, tree_total1$tip.label[x])

## create co-phylogenetic object
rod.cophylo<-cophylo(mytree5,tree_total1,
                      assoc=association)

## plot co-phylogenies
pdf(file="cophylo.pdf",height=20,width=11)
plot(rod.cophylo,link.type="curved",link.lwd=1,
            link.lty="solid",link.col=make.transparent("red",
                                                       0.25))
dev.off()

