library(tidyr)
library(dplyr)
library(ggplot2)
require(ggtree)
library(devtools)
#install_github("jokergoo/ComplexHeatmap")
library(ComplexHeatmap)
library(circlize)
library(ape)
library(stringr)
library(Hmisc)
library(phylogram)
library(RColorBrewer)


#########################################################################
### FUNCTION fheatmap

fheatmap_wgcna=function(dset ,sptree, folder,hei=5, MEs0, genes, pc_df2)
{  
sporder=sptree$tip.label

# MEs0 contains Module Eigengenes per cluster (hypothetical central gene)

# grey cluster is the non-clustered genes : to be removed
MEs0 <- MEs0[,!names(MEs0)%in%c("MEgrey","total_group_batch","ancient_group_batch","recent_group_batch","species")]
genes<-genes[genes$colors!="grey",] 
n_mod=length(grep("ME",names(MEs0)))
nSamples = nrow(pc_df2)

pc_df2=pc_df2[,!names(pc_df2)%in%c("total_group_batch","ancient_group_batch","recent_group_batch")]

MEs0b=merge(MEs0,pc_df2,by.x="samples",0)
names(MEs0b)=gsub("ME","",names(MEs0b))
panovaXM=sapply(2:(n_mod+1),function(x){summary(aov(lm(MEs0b[,x]~MEs0b$"cond_season.x")))[[1]]["Pr(>F)"][[1]][1]})
ranovaXM=sapply(2:(n_mod+1),function(x){summary(lm(MEs0b[,x]~MEs0b$"cond_season.x"))$"adj.r.squared"})
sanovaXM=sapply(2:(n_mod+1),function(x){summary(lm(MEs0b[,x]~MEs0b$"cond_season.x"))$coefficients["MEs0b$cond_season.xmesic","Estimate"]>0})
names(ranovaXM)=names(MEs0b)[2:(n_mod+1)]
names(panovaXM)=names(MEs0b)[2:(n_mod+1)]
names(sanovaXM)=names(MEs0b)[2:(n_mod+1)]

mat <- cbind(MEs0b[,"Bio17.without"],MEs0b[,grep("ME",names(MEs0))])
names(mat)[1] = "Bio17.without"
cor_2 <- rcorr(as.matrix(mat))
CorWithDeconv <- as.data.frame(cor_2$r["Bio17.without",grep("ME",names(mat))])
CorWithDeconv_p<- as.data.frame(cor_2$P["Bio17.without",grep("ME",names(mat))])
names(CorWithDeconv_p)="Bio17.without"
names(CorWithDeconv)="Bio17.without"

MEs0long <- MEs0b %>%
  select(-c("PC1" ,"PC2","PC3","PC4","PC5","group","species","ID_final","sp_short_name.y", "cond_season.y"))%>%
  pivot_longer(cols=-c("samples", "sp_short_name.x", "cond_season.x", "Bio17.without" ), names_to = "module", values_to = "value") %>%
  group_by(sp_short_name.x,module,cond_season.x) %>%
  summarise(averagevalue = mean(value, na.rm = TRUE)) 


# dendrogram to reorder the modules based on average per species

MEs0wide_means <- MEs0b %>%
  pivot_longer(cols=-c("samples", "sp_short_name.x", "cond_season.x", "PC1" ,           
                       "PC2","PC3","PC4","PC5","group","species","ID_final","sp_short_name.y", "cond_season.y","Bio17.without"), names_to = "module", values_to = "value") %>%
  as_tibble() %>% 
  dplyr::select(-c("samples",  "PC1" ,           
                   "PC2","PC3","PC4","PC5","group","species","ID_final","sp_short_name.y", "cond_season.y","Bio17.without")) %>%
  pivot_wider(
    names_from = c(module),
    values_from = value,
    values_fn = mean)

hc <- hclust(dist(t(MEs0wide_means[,!names(MEs0wide_means)%in%c("sp_short_name.x","cond_season.x")])))

shortmodulename <- sub("ME", "", names(MEs0wide_means)[hc$order+2])
names(MEs0wide_means) <- sub("ME", "", names(MEs0wide_means))
MEs0wide_means <- data.frame(MEs0wide_means)
rownames(MEs0wide_means) <- MEs0wide_means$sp_short_name


# nb genes per module
nbgenes <- table(genes$colors)
nbgenes_order <- nbgenes[shortmodulename]

MEs0wide_means <- MEs0wide_means[sporder[length(sporder):1],]
shortmodulename <- sub("ME", "", names(MEs0wide_means)[hc$order+2])

# g<-ggplot(MEs0long, aes(y = sp_short_name, x = module, fill = averagevalue)) +
#   geom_tile(color = "black") +
#   scale_fill_gradient2(high = "#075AFF", low = "red") +
#   coord_fixed() +
#   scale_x_discrete(NULL,limits=names(MEs0wide_means)[hc$order+2],label=shortmodulename)+
#   scale_y_discrete(NULL,limits=speciesorder[length(speciesorder):1])+
#   theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1))


pvalue = panovaXM
is_sig = pvalue < 0.05
pch = rep("u*", length(panovaXM))
pch[sanovaXM==FALSE] = "o*"
pch[!is_sig] = NA
names(pch)=names(panovaXM)
rvalue_col_fun = colorRamp2(c(0,1), c("white","black"))
names(pch) <- sub("ME", "", names(pch))



#rvalue_col_fun = colorRamp2(c(-1, 0,1), c("darkgreen","white","orange")) 

ha = HeatmapAnnotation(
  rvalue = anno_simple(ranovaXM[hc$order], pch = pch[hc$order]),
  annotation_name_side = "left",
  col = list(rvalue=rvalue_col_fun)
  )
column_ha = HeatmapAnnotation(cor= anno_simple(ranovaXM[hc$order], pch = pch[hc$order],
                                               col=rvalue_col_fun), 
                              n_genes = anno_barplot(as.numeric(nbgenes[hc$order])))

ord = names(pch[order(pch)])
column_ha2 = HeatmapAnnotation(cor= anno_simple(ranovaXM[ord], pch = pch[ord],
                                               col=rvalue_col_fun), 
                              n_genes = anno_barplot(as.numeric(nbgenes[ord])))



row_ha = rowAnnotation(status = MEs0wide_means$cond_season,col=list(status=(c("arid"="#FFA500", "mesic"="#5EA336"))))

eigengene_col_fun <- colorRamp2(
  c(min(MEs0wide_means[,-c(1:2)], na.rm = TRUE),
    0,
    max(MEs0wide_means[,-c(1:2)], na.rm = TRUE)),
  c("blue", "white", "red")
)

#lgd_rvalue = Legend(title = "correlation", col_fun = rvalue_col_fun, 
#                    labels = c("0", "0.5"))
# and one for the significant p-values
#lgd_sig = Legend(pch = "*", type = "points", labels = "< 0.01")
# these two self-defined legends are added to the plot by `annotation_legend_list`
pdf(file=paste0(folder,"WGCNA_heatmap_",dset,"_byphyl.pdf"),height = hei,width = 5)
h<- Heatmap(MEs0wide_means[,hc$order+2], 
            show_row_dend = TRUE,
            show_column_dend = FALSE,
            name = "eigen genes", 
            #row_order = length(sporder):1, 
            #cluster_rows = reorder(as.dendrogram(sptree),13:1),
            cluster_rows = as.dendrogram(sptree),
            #row_dend_reorder = TRUE,
            #column_order = hc$order,
            #row_km = 7,
            top_annotation = column_ha,
            col = eigengene_col_fun)
            #, 
            #right_annotation = row_ha)
#draw(h, annotation_legend_list = list(lgd_rvalue, lgd_sig))
draw(h)
dev.off()

pdf(file=paste0(folder,"WGCNA_heatmap_",dset,"_bycond.pdf"),height = hei,width = 5)
h<- Heatmap(MEs0wide_means[,hc$order+2], 
        show_row_dend = TRUE,
        show_column_dend = FALSE,
        name = "eigen genes", 
        row_order = length(sporder):1, 
        #cluster_rows = sptree,
        #column_order = hc$order,
        top_annotation = column_ha, 
        right_annotation = row_ha,
        row_split = MEs0wide_means$cond_season,
        col = eigengene_col_fun)
#draw(h, annotation_legend_list = list(lgd_rvalue, lgd_sig))
draw(h)
dev.off()

m=MEs0wide_means[,3:ncol(MEs0wide_means)]
m=m[,order(pch)]

pdf(file=paste0(folder,"WGCNA_heatmap_",dset,"_bycond2.pdf"),height = hei,width = 5)
h<- Heatmap(m, 
            show_row_dend = TRUE,
            show_column_dend = FALSE,
            name = "eigen genes", 
            row_order = length(sporder):1, 
            top_annotation = column_ha2, 
            right_annotation = row_ha,
            column_order = names(m),
            row_split = MEs0wide_means$cond_season,
            col = eigengene_col_fun)
#draw(h, annotation_legend_list = list(lgd_rvalue, lgd_sig))
draw(h)
dev.off()


}


#########################################################################
### RUN dataset

### MURINAE DATASET (not used in paper)
dset="murinae"
folder="dataset_muridae_WGCNA_power20_0910/"
MEs0=read.table(paste0(folder,"Table_MEs0.tsv"),sep = "\t",  h=T)
genes_mur=read.table(paste0(folder,"Table_gene_modules_q50.txt"), sep = "\t",  h=T)
pc_df2_mur=read.table(paste0(folder,"Table_PC.tsv"), sep = "\t", h=T)
pc_df2_mur$PC1 <- -1 * pc_df2_mur$PC1

tree_murinae=read.tree("tree_nw/tree_dataset_murinae_sequences_raw_sp.nw")
tree_murinae=drop.tip(tree_murinae, c("Nannomys_cot","Mus_pahari","Mus_spretus","Mus_spicilegus",
                                      "Arvicanthis_niloticus_lmo"))
firstL=str_extract(tree_murinae$tip.label, "^[:upper:]")
threeL=str_extract(tree_murinae$tip.label,"_[a-z]{1,2}")
tree_murinae_3letters = paste0(firstL,gsub("_","",threeL))
tree_murinae_3letters[tree_murinae$tip.label=="Mus_musculus_ddo"]="Mmu_ddo"
tree_murinae_3letters[tree_murinae$tip.label=="Mus_musculus_wla"]="Mmu_wla"
tree_murinae$tip.label=tree_murinae_3letters
tree_murinae <- rotate(tree_murinae, c("Mma", "Mmu_ddo"))


fheatmap_wgcna(dset="murinae",sptree=tree_murinae,
               folder=folder, hei=5,
               MEs0=MEs0, genes=genes_mur, pc_df2=pc_df2_mur
)


### TOTAL DATASET (used in paper Figure 1d)
dset="total"
folder="dataset_tot_WGCNA_q50_power5_0910/"
tree_total=read.tree("tree_nw/tree_dataset_total_sequences_raw_sp.nw")
MEs0=read.table(paste0(folder,"Table_MEs0.tsv"),sep = "\t",  h=T)
genes_tot=read.table(paste0(folder,"Table_gene_modules_q50.txt"), sep = "\t",  h=T)
pc_df2_tot=read.table(paste0(folder,"Table_PC.tsv"), sep = "\t", h=T)


firstL=str_extract(tree_total$tip.label, "^[:upper:]")
threeL=str_extract(tree_total$tip.label,"_[a-z]{1,2}")
tree_total_3letters = paste0(firstL,gsub("_","",threeL))
tree_total_3letters[tree_total$tip.label=="Mus_musculus_ddo"]="Mmu_ddo" #or Mddo
tree_total_3letters[tree_total$tip.label=="Mus_musculus_wla"]="Mmu_wla" #or Mwla
tree_total_3letters[tree_total$tip.label=="Arvicanthis_niloticus_sen"]="Ani_sen"

## keep relevant species
unique(MEs0$sp_short_name)[!unique(MEs0$sp_short_name)%in%tree_total_3letters]
tree_total$tip.label[!tree_total_3letters%in%unique(MEs0$sp_short_name)]
tree_total=drop.tip(tree_total,c("Cavia_aperea","Octodon_degus","Dipodomys_ordii",               
"Castor_canadensis","Jaculus_jaculus","Nannospalax_galili","Marmota_marmota_marmota",            
"Nannomys_cot","Mus_pahari","Mus_spretus",                   
"Mus_spicilegus","Arvicanthis_niloticus_lmo",     
"Peromyscus_leucopus","Microtus_ochrogaster","Cricetulus_griseus_crigri",     
"Ictidomys_tridecemlineatus","Urocitellus_parryii","Spermophilus_dauricus"))       
firstL=str_extract(tree_total$tip.label, "^[:upper:]")
threeL=str_extract(tree_total$tip.label,"_[a-z]{1,2}")
tree_total_3letters = paste0(firstL,gsub("_","",threeL))
tree_total_3letters[tree_total$tip.label=="Mus_musculus_ddo"]="Mmu_ddo"
tree_total_3letters[tree_total$tip.label=="Mus_musculus_wla"]="Mmu_wla"
tree_total_3letters[tree_total$tip.label=="Arvicanthis_niloticus_sen"]="Ani_sen"

tree_total$tip.label=tree_total_3letters

fheatmap_wgcna(dset="total",sptree=tree_total,
               folder=folder, hei=7,
               MEs0=MEs0, genes=genes_tot, pc_df2=pc_df2_tot)



### BETWEEN-GENERA DATASET (used in paper Figure 4)
dset="ancient"
tree_ancient=read.tree("tree_nw/tree_dataset_ancient_trans_sequences_raw_sp.nw")
firstL=str_extract(tree_ancient$tip.label, "^[:upper:]")
threeL=str_extract(tree_ancient$tip.label,"_[a-z]{1,2}")
tree_ancient_3letters = paste0(firstL,gsub("_","",threeL))
tree_ancient_3letters[tree_ancient$tip.label=="Mus_musculus_ddo"]="Mddo"
tree_ancient_3letters[tree_ancient$tip.label=="Mus_musculus_wla"]="Mwla"
tree_ancient_3letters[tree_ancient$tip.label=="Arvicanthis_niloticus_sen"]="Ani_sen"
folder="dataset_ancient_WGCNA_q50_power20_0910/"
MEs0=read.table(paste0(folder,"Table_MEs0.tsv"),sep = "\t",  h=T)
unique(MEs0$sp_short_name)[!unique(MEs0$sp_short_name)%in%tree_ancient_3letters]
tree_ancient$tip.label[!tree_ancient_3letters%in%unique(MEs0$sp_short_name)]
tree_ancient=drop.tip(tree_ancient,c("Castor_canadensis","Mus_pahari","Mus_spretus",                   
"Mus_spicilegus","Arvicanthis_niloticus_lmo","Peromyscus_maniculatus_bairdii",
"Peromyscus_leucopus","Abrothrix_longipilis","Abrothrix_olivaceus",   
"Myodes_glareolus","Microtus_ochrogaster","Dendromus_melanotis",        
"Cavia_aperea","Marmota_marmota_marmota","Ictidomys_tridecemlineatus",    
"Tamias_sibiricus"))   
  
firstL=str_extract(tree_ancient$tip.label, "^[:upper:]")
threeL=str_extract(tree_ancient$tip.label,"_[a-z]{1,2}")
tree_ancient_3letters = paste0(firstL,gsub("_","",threeL))
tree_ancient_3letters[tree_ancient$tip.label=="Mus_musculus_ddo"]="Mmu_ddo"
tree_ancient_3letters[tree_ancient$tip.label=="Mus_musculus_wla"]="Mmu_wla"
tree_ancient_3letters[tree_ancient$tip.label=="Arvicanthis_niloticus_sen"]="Ani_sen"
tree_ancient$tip.label=tree_ancient_3letters
genes_ancient=read.table(paste0(folder,"Table_gene_modules_q50.txt"), sep = "\t",  h=T)

pc_df2_ancient=read.table(paste0(folder,"Table_PC.tsv"), sep = "\t", h=T)


fheatmap_wgcna(dset="ancient",sptree=tree_ancient,
  folder=folder, hei=7,
  MEs0=MEs0, genes=genes_ancient, pc_df2=pc_df2_ancient)


### WITHIN-GENERA DATASET (used in paper Figure 4)

dset="recent"
tree_recent=read.tree("tree_nw/tree_dataset_recent_trans_sequences_raw_sp.nw")
firstL=str_extract(tree_recent$tip.label, "^[:upper:]")
threeL=str_extract(tree_recent$tip.label,"_[a-z]{1,2}")
tree_recent_3letters = paste0(firstL,gsub("_","",threeL))
tree_recent_3letters[tree_recent$tip.label=="Mus_musculus_ddo"]="Mmu_ddo"
tree_recent_3letters[tree_recent$tip.label=="Mus_musculus_wla"]="Mmu_wla"
tree_recent_3letters[tree_recent$tip.label=="Arvicanthis_niloticus_sen"]="Ani_sen"

folder="dataset_recent_WGCNA_q50_power8_0910/"
MEs0=read.table(paste0(folder,"Table_MEs0.tsv"),sep = "\t",  h=T)
genes_recent=read.table(paste0(folder,"Table_gene_modules_q50.txt"), sep = "\t",  h=T)
pc_df2_recent=read.table(paste0(folder,"Table_PC.tsv"), sep = "\t", h=T)


unique(MEs0$sp_short_name)[!unique(MEs0$sp_short_name)%in%tree_recent_3letters]
tree_recent$tip.label[!tree_recent_3letters%in%unique(MEs0$sp_short_name)]
tree_recent=drop.tip(tree_recent,c("Castor_canadensis","Heteromys_desmarestianus",
"Peromyscus_leucopus","Microtus_ochrogaster","Nannomys_cot",
"Mus_pahari","Mus_spretus","Mus_spicilegus","Arvicanthis_niloticus_lmo",
"Dendromus_melanotis","Cavia_porcellus","Cavia_aperea","Ictidomys_tridecemlineatus","Tamias_sibiricus","Marmota_marmota_marmota"))   

firstL=str_extract(tree_recent$tip.label, "^[:upper:]")
threeL=str_extract(tree_recent$tip.label,"_[a-z]{1,2}")
tree_recent_3letters = paste0(firstL,gsub("_","",threeL))
tree_recent_3letters[tree_recent$tip.label=="Mus_musculus_ddo"]="Mmu_ddo"
tree_recent_3letters[tree_recent$tip.label=="Mus_musculus_wla"]="Mmu_wla"
tree_recent_3letters[tree_recent$tip.label=="Arvicanthis_niloticus_sen"]="Ani_sen"
tree_recent$tip.label=tree_recent_3letters

fheatmap_wgcna(dset="recent",sptree=tree_recent,
               folder=folder, hei=7,
               MEs0=MEs0, genes=genes_recent, pc_df2=pc_df2_recent)


### MURINAE DATASET + CELL PROPORTIONS FROM DECONVOLUTIONS (used in paper Figure 4)

fheatmap_wgcna_with_deconv=function(dset="murinae" ,sptree=tree_murinae, folder="2.3_WGCNA-20240119T132302Z-001/2.3_WGCNA/murinae/Without_Ncot",hei=5)
{  
  MEs0=read.table(paste0(folder,"/Eigengene_module_wgcna_par_ind_", dset,".tsv"), sep = "\t",  h=T)
  genes=read.table(paste0(folder,"/corrected_gene_modules_q50.txt"), sep = "\t",  h=T)
  pc_df2=read.table(paste0(folder,"/meta_df_with_PC_cell_prop_", dset,"_invPC1.tsv"), sep = "\t", h=T)
  pc_df2$ID=gsub("Mastomys_kollmannspergeri","Mastomys_kollmanspergeri",pc_df2$ID)
  pc_df=read.table("prop_music.txt", sep = " ", h=T)
  pc_df2=merge(pc_df2,pc_df,by.x="ID",by.y=0)
  pc_df2=pc_df2[,-grep("med",names(pc_df2))]
  write.table(pc_df2,file="meta_df_murine.txt")
  # MEs0 contains Module Eigengenes per cluster (hypothetical central gene)

  # grey cluster is the non-clustered genes : to be removed
  MEs0 <- MEs0[,!names(MEs0)%in%c("MEgrey","total_familydeseq2","ancient_trans_familydeseq2","recent_trans_familydeseq2")]
  genes<-genes[genes$colors!="grey",] 
  n_mod=length(grep("ME",names(MEs0)))
  nSamples = nrow(pc_df2)
  
  pc_df3=merge(MEs0,pc_df2,by.x="samples",by.y="name")
  panovaXM=sapply(2:(n_mod+1),function(x){summary(aov(lm(pc_df3[,x]~pc_df3$"cond_season.y")))[[1]]["Pr(>F)"][[1]][1]})
  ranovaXM=sapply(2:(n_mod+1),function(x){summary(lm(pc_df3[,x]~pc_df3$"cond_season.y"))$"adj.r.squared"})
  sanovaXM=sapply(2:(n_mod+1),function(x){summary(lm(pc_df3[,x]~pc_df3$"cond_season.y"))$coefficients["pc_df3$cond_season.yxeric","Estimate"]>0})
  names(ranovaXM)=names(pc_df3)[2:(n_mod+1)]
  names(panovaXM)=names(pc_df3)[2:(n_mod+1)]
  names(sanovaXM)=names(MEs0)[2:(n_mod+1)]
  
  mat <- cbind(pc_df3[,c("CD","Podo","Endo","LOH","PT")],pc_df3[,grep("ME",names(pc_df3))])
  cor_2 <- rcorr(as.matrix(mat))
  CorWithDeconv <- as.data.frame(cor_2$r[c("CD","Podo","Endo","LOH","PT"),grep("ME",names(mat))])
  CorWithDeconv_p<- as.data.frame(cor_2$P[c("CD","Podo","Endo","LOH","PT"),grep("ME",names(mat))])
  
  names(CorWithDeconv) <- sub("ME", "", names(CorWithDeconv))
  names(CorWithDeconv_p) <- sub("ME", "", names(CorWithDeconv))
  CorWithDeconv_pch = CorWithDeconv_p
  is_sig = CorWithDeconv_p < 0.05
  CorWithDeconv_pch[!is_sig] = NA
  CorWithDeconv_pch[is_sig] = "*"
  
  MEs0long <- MEs0 %>%
    pivot_longer(cols=-c("samples","sp_short_name","cond_season"), names_to = "module", values_to = "value") %>%
    group_by(sp_short_name,module,cond_season) %>%
    summarise(averagevalue = mean(value, na.rm = TRUE)) 
  
  # dendrogram to reorder the modules based on average per species
  MEs0wide_means <- MEs0 %>%
    pivot_longer(cols=-c("samples","sp_short_name","cond_season"), names_to = "module", values_to = "value") %>%
    as_tibble() %>% 
    dplyr::select(-samples) %>%
    pivot_wider(
      names_from = c(module),
      values_from = value,
      values_fn = mean)
  
  hc <- hclust(dist(t(MEs0wide_means[,-c(1,2)])))
  
  shortmodulename <- sub("ME", "", names(MEs0wide_means)[hc$order+2])
  names(MEs0wide_means) <- sub("ME", "", names(MEs0wide_means))
  MEs0wide_means <- data.frame(MEs0wide_means)
  rownames(MEs0wide_means) <- MEs0wide_means$sp_short_name
  
  
  # nb genes per module
  nbgenes <- table(genes$colors)
  nbgenes_order <- nbgenes[shortmodulename]
  
  MEs0wide_means <- MEs0wide_means[sporder[length(sporder):1],]
  shortmodulename <- sub("ME", "", names(MEs0wide_means)[hc$order+2])
   pvalue = panovaXM[hc$order]
  sign = sanovaXM[hc$order]
  is_sig = pvalue < 0.05
  pch = rep("u*", length(hc$order))
  pch[sign==TRUE] = "o*"
  pch[!is_sig] = NA
  rvalue_col_fun = colorRamp2(c(0,1), c("white","black"))
  
  ha = HeatmapAnnotation(
    rvalue = anno_simple(ranovaXM[hc$order], pch = pch),
    annotation_name_side = "left",
    col = list(rvalue=rvalue_col_fun)
  )
  
  column_ha = HeatmapAnnotation(cor= anno_simple(ranovaXM[hc$order], pch = pch,
                                                 col=rvalue_col_fun), 
                                n_genes = anno_barplot(as.numeric(nbgenes_order)))
  row_ha = rowAnnotation(status = MEs0wide_means$cond_season,col=list(status=(c("xeric"="orange", "mesic"="darkgreen"))))
  
  colo=colorRampPalette(c("navy", "white", "firebrick3"))(50)

  coloMain=colorRampPalette(brewer.pal(8, "RdGy"))(50)
  
  
  h<- Heatmap(MEs0wide_means[,hc$order+2], 
              cluster_rows = FALSE,
              show_column_dend = FALSE,
              name = "eigen genes", 
              row_order = length(sporder):1, 
              col=coloMain,
              #column_order = hc$order,
              top_annotation = column_ha, 
              right_annotation = row_ha)
 
  CorWithDeconv_p <- CorWithDeconv_p[,hc$order]
  CorWithDeconv_pch <- CorWithDeconv_pch[,hc$order]
  
  cdeconv<- Heatmap(CorWithDeconv[,hc$order], 
                    cluster_rows = TRUE,
                    show_column_dend = FALSE,
                    show_row_dend = FALSE,
                    name = "correlations",
                    col=colo,
                    cell_fun = function(j, i, x, y, width, height, fill) {
                      if(CorWithDeconv_p[i, j] < 0.1)
                      grid.text(sprintf("%.e", CorWithDeconv_p[i, j]), x, y, gp = gpar(fontsize = 6))
                    })
  
  ht_list =  h  %v%  cdeconv
  
  pdf("WGCNA_heatmap_murinae_withdeconv.pdf")
  draw(ht_list)
  dev.off()
}

fheatmap_wgcna_with_deconv(dset="murinae",sptree=tree_murinae, folder="2.3_WGCNA-20240119T132302Z-001/2.3_WGCNA/murinae/Without_Ncot"
)


