
set -e
centrifuger="centrifuger"
tool_name="centrifuger"
threads=64

# paras
$wd
$scripts_dir
$dataset #simlow
$data_type #30/1000
$read_type #short/long
$samplesID #ngs/hifi
$profile_level
$read
$read1
$read2
$camisim_reads_mapping_path
$true_abund
$read_length
$genome_length
$genomes_length_for_strains
$database_genomes_info
$db
$designated_genomes_info

# dir
echo "###########################################################################################"
echo "Running $tool_name..."
mkdir -p $wd/$tool_name/$profile_level && cd $wd/$tool_name/$profile_level
mkdir -p $wd/$tool_name/$profile_level/$dataset/$samplesID && cd $wd/$tool_name/$profile_level/$dataset/$samplesID

# short
if [ ! -f centrifuger_report.tsv ]; then
    /usr/bin/time -v -o query_time.log $centrifuger -k 1 -x $db -1 $read1 -2 $read2 -t $threads > cls.tsv
    centrifuger-quant -x $db -c cls.tsv > centrifuger_report.tsv
    python $scripts_dir/time_process.py query_time.log > time_evaluation.txt
fi
if [ ! -f "evaluation_report.txt" ]; then
    if [ $profile_level == "strain_level" ]; then
        python $scripts_dir/centrifuger_strain_process.py centrifuger_report.tsv $designated_genomes_info
        python $scripts_dir/strain_evaluation.py strain_abundance.txt $tool_name $data_type $true_abund $database_genomes_info > evaluation_report.txt
    fi
fi

# long
if [ ! -f centrifuger_report.tsv ]; then
    /usr/bin/time -v -o query_time.log $centrifuger -k 1 -x $db -u $read -t $threads > cls.tsv
    centrifuger-quant -x $db -c cls.tsv > centrifuger_report.tsv
    python $scripts_dir/time_process.py query_time.log > time_evaluation.txt
fi
if [ ! -f "evaluation_report.txt" ]; then
    if [ $profile_level == "strain_level" ]; then
        python $scripts_dir/centrifuger_strain_process.py centrifuger_report.tsv $designated_genomes_info
        python $scripts_dir/strain_evaluation.py strain_abundance.txt $tool_name $data_type $true_abund $database_genomes_info > evaluation_report.txt
    fi
fi
