rm(list = ls())
getwd()

setwd("./1.genome_seq/macro_micro/")

marcoDNA <- read.table("macroDNA.txt",header = F)

microDNA <- read.table("microDNA.txt",header = F)

dfDNA <- data.frame(name = c(rep("Macro",time=815),rep("Micro",times=171)),
                    number = c(marcoDNA$V1,microDNA$V1)) 
head(dfDNA)

library(ggplot2)
library(ggpubr)

DNAp <- ggplot(dfDNA,aes(x = name,y = number,fill = name,col = name)) +
  geom_boxplot(size=2,outlier.colour = "NA",notch = T,notchwidth = 0.1) + border(color = "black",size = 3) + theme_bw() +
  labs(x = "",y = "") + 
  ggtitle("DNA") +
  theme(plot.title = element_text(hjust = 0.5,size = 14),
        axis.text = element_text(size = 12),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) + 
  guides(fill=F,col = F) +
  geom_signif(comparisons = list(c("Macro","Micro")),
              size = 1,textsize = 5,col = "black") +
  scale_fill_manual(values = c("#d73027","#4575b4")) +
  scale_color_manual(values = c("#d73027","#4575b4"))
  #####################################################
# LINE
marcoLINE <- read.table("marcoLINE.txt",header = F)

microLINE <- read.table("microLINE.txt",header = F)

dfLINE <- data.frame(name = c(rep("Macro",time=815),rep("Micro",times=171)),
                    number = c(marcoLINE$V1,microLINE$V1)) 
head(dfLINE)
LINEp <- ggplot(dfLINE,aes(x = name,y = number,fill = name,col = name)) +
  geom_boxplot(size=2,outlier.colour = "NA",notch = T) + border(color = "black",size = 3) + theme_bw() +
  labs(x = "",y = "") + 
  ggtitle("LINE") +
  theme(plot.title = element_text(hjust = 0.5,size = 14),
        axis.text = element_text(size = 12),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) + 
  guides(fill=F,col = F) +
  geom_signif(comparisons = list(c("Macro","Micro")),
              size = 1,textsize = 5,col = "black") +
  scale_fill_manual(values = c("#d73027","#4575b4")) +
  scale_color_manual(values = c("#d73027","#4575b4"))
######################################################
# LTR
marcoLTR <- read.table("marcoLTR.txt",header = F)

microLTR <- read.table("microLTR.txt",header = F)

dfLTR <- data.frame(name = c(rep("Macro",time=815),rep("Micro",times=171)),
                    number = c(marcoLTR$V1,microLTR$V1)) 
head(dfLTR)
LTRp <- ggplot(dfLTR,aes(x = name,y = number,fill = name,col = name)) +
  geom_boxplot(size=2,outlier.colour = "NA",notch = T) + border(color = "black",size = 3) + theme_bw() +
  labs(x = "",y = "") + 
  ggtitle("LTR") +
  theme(plot.title = element_text(hjust = 0.5,size = 14),
        axis.text = element_text(size = 12),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) + 
  guides(fill=F,col = F) +
  geom_signif(comparisons = list(c("Macro","Micro")),
              size = 1,textsize = 5,col = "black") +
  scale_fill_manual(values = c("#d73027","#4575b4")) +
  scale_color_manual(values = c("#d73027","#4575b4"))
#######################################################
# SINE
marcoSINE <- read.table("marcoSINE.txt",header = F)

microSINE <- read.table("microSINE.txt",header = F)

dfSINE <- data.frame(name = c(rep("Macro",time=815),rep("Micro",times=171)),
                    number = c(marcoSINE$V1,microSINE$V1)) 
head(dfSINE)
SINEp <- ggplot(dfSINE,aes(x = name,y = number,fill = name,col = name)) +
  geom_boxplot(size=2,outlier.colour = "NA",notch = T) + border(color = "black",size = 3) + theme_bw() +
  labs(x = "",y = "") + 
  ggtitle("SINE") +
  theme(plot.title = element_text(hjust = 0.5,size = 14),
        axis.text = element_text(size = 12),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) + 
  guides(fill=F,col = F) +
  geom_signif(comparisons = list(c("Macro","Micro")),
              parse = T,size = 1.5,textsize = 5,col = "black") +
  scale_fill_manual(values = c("#d73027","#4575b4")) +
  scale_color_manual(values = c("#d73027","#4575b4"))
##############################################################
# Satellite
marcoSatellite <- read.table("marcoSatellite.txt",header = F)

microSatellite <- read.table("microSatellite.txt",header = F)

dfSatellite <- data.frame(name = c(rep("Macro",time=815),rep("Micro",times=171)),
                    number = c(marcoSatellite$V1,microSatellite$V1)) 
head(dfSatellite)
Satellitep <- ggplot(dfSatellite,aes(x = name,y = number,fill = name,col = name)) +
  geom_boxplot(size=2,outlier.colour = "NA",notch = T) + border(color = "black",size = 3) + theme_bw() +
  labs(x = "",y = "") + 
  ggtitle("Satellite") +
  theme(plot.title = element_text(hjust = 0.5,size = 14),
        axis.text = element_text(size = 12),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) + 
  guides(fill=F,col = F) +
  geom_signif(comparisons = list(c("Macro","Micro")),
              size = 1,textsize = 5,col = "black") +
  scale_fill_manual(values = c("#d73027","#4575b4")) +
  scale_color_manual(values = c("#d73027","#4575b4"))
#####################################################
# Simple_repeat
marcoSimple_repeat <- read.table("marcoSimple_repeat.txt",header = F)

microSimple_repeat <- read.table("microSimple_repeat.txt",header = F)

dfSimple_repeat <- data.frame(name = c(rep("Macro",time=815),rep("Micro",times=171)),
                    number = c(marcoSimple_repeat$V1,microSimple_repeat$V1)) 
head(dfSimple_repeat)
Simple_repeatp <- ggplot(dfSimple_repeat,aes(x = name,y = number,fill = name,col = name)) +
  geom_boxplot(size=2,outlier.colour = "NA",notch = T) + border(color = "black",size = 3) + theme_bw() +
  labs(x = "",y = "") + 
  ggtitle("Simple repeat") +
  theme(plot.title = element_text(hjust = 0.5,size = 14),
        axis.text = element_text(size = 12),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) + 
  guides(fill=F,col = F) +
  geom_signif(comparisons = list(c("Macro","Micro")),
              size = 1,textsize = 5,col = "black") +
  scale_fill_manual(values = c("#d73027","#4575b4")) +
  scale_color_manual(values = c("#d73027","#4575b4"))
#########################################################
# ALL repeat
marcoAllrepeat <- read.table("marcoAllrepeat.txt",header = F)

microAllrepeat <- read.table("microAllrepeat.txt",header = F)

dfAllrepeat <- data.frame(name = c(rep("Macro",time=815),rep("Micro",times=171)),
                    number = c(marcoAllrepeat$V1,microAllrepeat$V1)) 
head(dfAllrepeat)
Allrepeatp <- ggplot(dfAllrepeat,aes(x = name,y = number,fill = name,col = name)) +
  geom_boxplot(size=2,outlier.colour = "NA",notch = T) + border(color = "black",size = 3) + theme_bw() +
  labs(x = "",y = "") + 
  ggtitle("All repeats") +
  theme(plot.title = element_text(hjust = 0.5,size = 14),
        axis.text = element_text(size = 12),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) + 
  guides(fill=F,col = F) +
  geom_signif(comparisons = list(c("Macro","Micro")),
              size = 1,textsize = 5,col = "black") +
  scale_fill_manual(values = c("#d73027","#4575b4")) +
  scale_color_manual(values = c("#d73027","#4575b4"))
##########################################
# GC
marcoGC <- read.table("macroGC.txt",header = F,sep = "\t")

microGC <- read.table("microGC.txt",header = F,sep = "\t")

dfGC <- data.frame(name = c(rep("Macro",time=815),rep("Micro",times=171)),
                    number = c(marcoGC$V4,microGC$V4)) 
head(dfGC)
GCp <- ggplot(dfGC,aes(x = name,y = number,fill = name,col = name)) +
  geom_boxplot(size=2,outlier.colour = "NA",notch = T) + border(color = "black",size = 3) + theme_bw() +
  labs(x = "",y = "") + 
  ggtitle("GC") +
  theme(plot.title = element_text(hjust = 0.5,size = 14),
        axis.text = element_text(size = 12),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) + 
  guides(fill=F,col = F) +
  geom_signif(comparisons = list(c("Macro","Micro")),
              size = 1,textsize = 5,col = "black") +
  scale_fill_manual(values = c("#d73027","#4575b4")) +
  scale_color_manual(values = c("#d73027","#4575b4"))

######################################################
# Gene density
marcoGene <- read.table("macroGene.txt",header = F,sep = "\t")

microGene <- read.table("microGene.txt",header = F,sep = "\t")

dfGene <- data.frame(name = c(rep("Macro",time=815),rep("Micro",times=171)),
                    number = c(marcoGene$V4,microGene$V4)) 
head(dfGene)
Genep <- ggplot(dfGene,aes(x = name,y = number,fill = name,col = name)) +
  geom_boxplot(size=2,outlier.colour = "NA",notch = T) + border(color = "black",size = 3) + theme_bw() +
  labs(x = "",y = "") + 
  ggtitle("Gene density") +
  theme(plot.title = element_text(hjust = 0.5,size = 14),
        axis.text = element_text(size = 12),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) + 
  guides(fill=F,col = F) +
  geom_signif(comparisons = list(c("Macro","Micro")),
              size = 1,textsize = 5,col = "black") +
  scale_fill_manual(values = c("#d73027","#4575b4")) +
  scale_color_manual(values = c("#d73027","#4575b4"))
############################################################
library(patchwork)

DNAp+LINEp+LTRp+SINEp+Satellitep+Simple_repeatp + Allrepeatp + GCp + Genep +
  plot_layout(ncol = 3)
  
