#!/usr/bin/bash

ref=$1 # must be prefix name and genome ends with .fasta
qur=$2

if [ $# -lt 2 ];then
	echo -e "Please input the reference genome and query genome's prefix name,and genome name ends with .fasta\n";
	exit;
else
	mkdir -p $1_$2 && cd $1_$2
	lastdb -uNEAR -cR11 -P10 ${ref}.db ../${ref}.fasta
	lastal -P10 -m100 -E0.05 ${ref}.db ../${qur}.fasta | last-split -m1 > ${ref}.${qur}.maf
	maf-swap ${ref}.${qur}.maf |last-split > ${ref}.${qur}.swap.maf
	
	perl maf.rename.species.S.pl ${ref}.${qur}.swap.maf $qur $ref ${ref}.${qur}.swap.name.maf

	perl maf2region_lzs.pl ${ref}.${qur}.swap.name.maf ${ref}.${qur}
	
	echo "$ref and $qur whole genome alignment was Done!!!\n";
	touch "done";
fi

