library(ggplot2)

#for each dataset, percentage of cells expressing xist per sample and cell type were calculated
#These were compiled into a single csv file for humans and mice, which are used here for plotting

data <- read.csv("/Users/kevinoleary/Dropbox (EinsteinMed)/Result_from_KevinO/neuron.xist/paper/tables/percent.expressing.xist.by.sample.cell.type.human.csv")
data$sex[data$sex == "M"] <- "Male"
data$sex[data$sex == "F"] <- "Female"

ggplot(data, aes(x = cell.type, y = percent.XIST.pos, color = cell.type))+
  geom_boxplot()+
  facet_wrap(sex~dataset, drop = T, scales = "free")+
  theme(axis.text.x = element_text(angle = 45, hjust = 1))+
  labs(y = "% XIST+",
       x = "Cell Type")+
  NoLegend()

data <- read.csv("/Users/kevinoleary/Dropbox (EinsteinMed)/Result_from_KevinO/neuron.xist/paper/tables/percent.expressing.xist.by.sample.cell.type.mouse.csv")

ggplot(data, aes(x = cell.type, y = percent.XIST.pos, color = cell.type))+
  geom_boxplot()+
  facet_wrap(sex~dataset, drop = T, scales = "free")+
  theme(axis.text.x = element_text(angle = 45, hjust = 1))+
  labs(y = "% XIST+",
       x = "Cell Type")+
  NoLegend()
