#!/bin/bash

#Code adapted from code on Taylor lab github site

export NA=$1
cd ${NA}

# get damage coordinate and sequence of damage

# extract Cdipy reads
printf "${NA}_damage.bed\n${NA}_trinuc.fa\n" | perl ../extract_TCG_reads.pl >${NA}_TCG.bed

# split strands
printf "${NA}_TCG.bed\n" | perl ../split_strands.pl 

# sort Cdipy reads for each strand
cat ${NA}_TCG_minusstrand.bed | sort -k1,1 -k2,2n -k 6 >${NA}_TCG_sorted_minusstrand.bed
cat ${NA}_TCG_plusstrand.bed | sort -k1,1 -k2,2n -k 6 >${NA}_TCG_sorted_plusstrand.bed

perl ../make_wig_mutations.pl <${NA}_TCG_sorted_minusstrand.bed >${NA}_TCG_sorted_minusstrand.wig
perl ../make_wig_mutations.pl <${NA}_TCG_sorted_plusstrand.bed >${NA}_TCG_sorted_plusstrand.wig

printf "${NA}_TCG_sorted_minusstrand.wig\n../initial_minus_CPDU_TCG.wig\n" | perl ../set_background.pl >${NA}_TCG_bk_minus.wig

printf "${NA}_TCG_sorted_plusstrand.wig\n../initial_plus_CPDU_TCG.wig\n" | perl ../set_background.pl >${NA}_TCG_bk_plus.wig

