#!/bin/bash

#Code adapted from code on Taylor lab github site

export NA=$1
cd ${NA}

# get damage coordinate and sequence of damage
perl ../CPDU_finddamagecoord.pl <${NA}.bed >${NA}_damage.bed
fastaFromBed -s -nameOnly -fi ../saccer3_genome.fa -bed ${NA}_damage.bed -fo ${NA}_damage.fa

# count damage nucleotides
perl ../count_nucleotides_MMS.pl <${NA}_damage.fa >${NA}_nucount.txt

# get trinuc bed
perl ../format_trinuc_context.pl <${NA}_damage.bed >${NA}_trinuc.bed
fastaFromBed -s -name -fi ../saccer3_genome.fa -bed ${NA}_trinuc.bed -fo ${NA}_trinuc.fa
# count trinuc
perl ../count_nucleotides_MMS.pl <${NA}_trinuc.fa >${NA}_newtrinucount.txt

# extract Cdipy reads
printf "${NA}_damage.bed\n${NA}_trinuc.fa\n" | perl ../extract_Cdipy_reads.pl >${NA}_Cdipy.bed

# split strands
printf "${NA}_Cdipy.bed\n" | perl ../split_strands.pl 

# sort Cdipy reads for each strand
cat ${NA}_Cdipy_minusstrand.bed | sort -k1,1 -k2,2n -k 6 >${NA}_Cdipy_sorted_minusstrand.bed
cat ${NA}_Cdipy_plusstrand.bed | sort -k1,1 -k2,2n -k 6 >${NA}_Cdipy_sorted_plusstrand.bed

perl ../make_wig_mutations.pl <${NA}_Cdipy_sorted_minusstrand.bed >${NA}_Cdipy_sorted_minusstrand.wig
perl ../make_wig_mutations.pl <${NA}_Cdipy_sorted_plusstrand.bed >${NA}_Cdipy_sorted_plusstrand.wig

printf "${NA}_Cdipy_sorted_minusstrand.wig\n../initial_minus_CPDU_Cdipy.wig\n" | perl ../set_background.pl >${NA}_Cdipy_bk_minus.wig

printf "${NA}_Cdipy_sorted_plusstrand.wig\n../initial_plus_CPDU_Cdipy.wig\n" | perl ../set_background.pl >${NA}_Cdipy_bk_plus.wig

