#!/bin/bash
#SBATCH --job-name=manual_curation
#SBATCH --output=delly_%j.log
#SBATCH --error=delly_%j.err
#SBATCH --time=24:00:00
#SBATCH --cpus-per-task=8
#SBATCH --mem=32G

CHR=`cat $TEXT/SV_info_samplot.txt | sed -n "${SLURM_ARRAY_TASK_ID}p" | cut -d " " -f1`
START=`cat $TEXT/SV_info_samplot.txt | sed -n "${SLURM_ARRAY_TASK_ID}p" | cut -d " " -f2`
STOP=`cat $TEXT/SV_info_samplot.txt | sed -n "${SLURM_ARRAY_TASK_ID}p" | cut -d " " -f3`
SV=`cat $TEXT/SV_info_samplot.txt | sed -n "${SLURM_ARRAY_TASK_ID}p" | cut -d " " -f4`
SAMPLE=`cat $TEXT/SV_info_samplot.txt | sed -n "${SLURM_ARRAY_TASK_ID}p" | cut -d " " -f5`

##############
# SAMPLOT
###############
samplot_latest.sif samplot plot \
-n $SAMPLE \
-b $BAM_DIR/${SAMPLE}_merged_recal.bam \
-o $PNG_DIR/${SAMPLE}_${SV}_${CHR}_${START}_${STOP}.png \
-c $CHR \
-s $START \
-e $STOP \
-t $SV
