#!/bin/bash
#SBATCH --job-name=combine_merge_truvari
#SBATCH --output=delly_%j.log
#SBATCH --error=delly_%j.err
#SBATCH --time=24:00:00
#SBATCH --cpus-per-task=8
#SBATCH --mem=32G

##############################
#MERGIMERGING DELLY AND MANTA
############################
picard_2.23.sif \
MergeVcfs \
--INPUT $DELLY/HET_${SAMPLE}_PASS_UNIQ_denovo.vcf.gz \
--INPUT $MANTA/${SAMPLE}_merged_MANTA.vcf.gz \
--OUTPUT $OVERLAP/${SAMPLE}_DELLY_MANTA.vcf

#############################
# ZIP AND INDEX SINE MERGED
#############################
bcftools view \
$OVERLAP/${SAMPLE}_DELLY_MANTA.vcf \
-Oz -o $OVERLAP/${SAMPLE}_DELLY_MANTA.vcf.gz

bcftools index -t -f $OVERLAP/${SAMPLE}_DELLY_MANTA.vcf.gz

##############################
# MERGING  SV CALLS TRUVARI
###############################
truvari \
collapse \
-i $OVERLAP/${SAMPLE}_DELLY_MANTA.vcf.gz \
-o $OUTPUT/merged/${SAMPLE}_TruvariMerged.vcf.gz \
-c $OUTPUT/collapsed/${SAMPLE}_TruvariCollapsed.vcf.gz \
-f $REF \
--pctsize 0.75 \
--pctovl 0.5 \
--pctseq 0.7 \
-s 20 \
-S 10000000 \
-k common \
--chain
