#!/bin/bash
#SBATCH --job-name=delly
#SBATCH --output=delly_%j.log
#SBATCH --error=delly_%j.err
#SBATCH --time=24:00:00
#SBATCH --cpus-per-task=8
#SBATCH --mem=32G

# Input files
REF=mm39.fa

# Run Delly (call + genotyping workflow)
# Step 1: Call SVs for all samples
delly call \
	-g $REF \
	-o $OUT_DIR/all_samples.bcf \
	-q 20 \
	-n \
	-m 20 \
	-t ALL \
	-f germline \
	-u 1000

# Step 2: Genotype each sample against the SV candidates
delly call \
	-g $REF \
	-v $OUT_DIR/all_samples.bcf \
	-o $OUT_DIR/${sample}.bcf \
	$bam
