#!/bin/bash

#SBATCH --job-name=MANTA
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=2
#SBATCH --time=200:00:00
#SBATCH --mem=600MB

#########################
# SV CALLING
#########################
configManta.py \
--bam $BAM_DIR/PARENT1.bam \
--bam $BAM_DIR/PARENT2_recal.bam \
--bam $BAM_DIR/${SAMPLE}_merged_recal.bam \
--referenceFasta ${REF} \
--runDir $OUT_DIR/${SAMPLE}

echo "workflow script complete"

#####################
# SUBMITTING RUNWORK
####################
python $OUT_DIR/${SAMPLE}/runWorkflow.py -m local -j 1 -g 10
echo "job complete"
