import os
from SigProfilerAssignment import Analyzer as Analyze

exclude_signature_subgroups = [
    'Immunosuppressants_signatures',
    'Treatment_signatures',
    'Tobacco_signatures',
    'UV_signatures',
    'AA_signatures',
    'Colibactin_signatures',
    'Artifact_signatures'
]

for i in range(1, 1001):
    input_file = f"replicate_{i}.txt"
    output_dir = f"/rep{i}/"
    
    # Make output directory if it doesn't exist
    os.makedirs(output_dir, exist_ok=True)

    # Check if input file exists
    if not os.path.exists(input_file):
        print(f"Missing input: {input_file}")
        continue

    Analyze.cosmic_fit(
        samples=input_file,
        output=output_dir,
        input_type="matrix",
        context_type="96",
        collapse_to_SBS96=True,
        cosmic_version=3.4,
        exome=False,
        genome_build="mm10",
        signature_database=None,
        exclude_signature_subgroups=exclude_signature_subgroups,
        export_probabilities=False,
        export_probabilities_per_mutation=False,
        make_plots=False)
