from SigProfilerAssignment import Analyzer as Analyze

samples = "trinucleotide_counts_by_sample.txt"
output = ""
input_type = "matrix"

exclude_signature_subgroups = [
    'Immunosuppressants_signatures',
    'Treatment_signatures',
    'Tobacco_signatures',
    'UV_signatures',
    'AA_signatures',
    'Colibactin_signatures',
    'Artifact_signatures',
]

Analyze.cosmic_fit(
    samples=samples,
    output=output,
    input_type=input_type,
    context_type="96",
    collapse_to_SBS96=True,
    cosmic_version=3.4,
    exome=False,
    genome_build="mm10",
    signature_database=None,
    exclude_signature_subgroups=exclude_signature_subgroups,
    export_probabilities=True,
    export_probabilities_per_mutation=False,
    make_plots=True,
    sample_reconstruction_plots="both",
    verbose=True
)
