library(tidyverse)

for(i in 1:1000){
  dat=read.table("../../trinucleotide_counts_by_sample.txt", sep="\t", header=T) %>% 
    select(-ART, -overall, -Natural)
  dat_names <- names(dat)[-1]
  names(dat)[-1] <- sample(dat_names, length(dat_names), replace = FALSE)


  group1_cols <- names(dat) %>% str_subset("\\.8\\d$")
  group2_cols <- names(dat) %>% str_subset("\\.5\\d{2}$")
  
  # Add group1 and group2 row sums
  dat <- dat %>%
    mutate(
      ART = rowSums(select(., all_of(group1_cols))),
      Natural = rowSums(select(., all_of(group2_cols)))
    ) %>% 
    select(MutationType, ART, Natural)
  
  write.table(dat, paste0("../../replicates/replicate_", i,".txt"), sep="\t", row.names = F, quote = F)
  gc()
}

