library(tidyverse)


dat <- bind_rows(read.csv("Natural_05_08IVF_spectrum.csv") %>%
                   mutate(type="Natural") %>% 
                   select(everything(), value=Natural),
                 read.csv("ART_05_08IVF_spectrum.csv") %>% mutate(type="ART") %>% 
                   select(everything(), value=ART)) %>% 
  separate(X, into=c("Alteration", "Context"), sep=" ") %>%
  mutate(Alteration = gsub("(.)(.)", "\\1>\\2", Alteration))

dat %>% 
  ggplot(aes(x=Context,y=value,fill=type)) +
  geom_bar(stat="identity", position="dodge") +
  facet_wrap(~Alteration, nrow=1) + 
  theme_classic() + 
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) + 
  scale_fill_manual(values = c("red", "dodgerblue3")) +
  ylab("Contribution") + 
  xlab("Motif")+
  theme(legend.position = "none")
ggsave("Combined_motif.png", height=3, width=15)
