library(tidyverse)
# if (!require("BiocManager", quietly = TRUE))
#   install.packages("BiocManager")
# BiocManager::install("SomaticSignatures")
library(SomaticSignatures)
#library(Rsamtools)
library(VariantAnnotation)
library(deconstructSigs)
library(ggfortify)
library(ggrepel)

citation("SomaticSignatures")
citation("VariantAnnotation")
citation("deconstructSigs")


files <- list.files(pattern="*.vcf")
ref="mm39.fa"
genome <- FaFile("mm39.fa")

for( i in 1:length(files)){
  vcfRange <- readVcfAsVRanges(files[i],ref)

  
  sca_motifs = tryCatch(mutationContext(vcfRange,
                                        genome),
                        error=function(e) e)
  
  sca_mm = motifMatrix(sca_motifs,
                       group = "sampleNames",
                       normalize = TRUE) #+ 0.0000000001
  
  sca_mm_count = motifMatrix(sca_motifs,
                       group = "sampleNames",
                       normalize = FALSE)
  
  plotMutationSpectrum(sca_motifs, "sampleNames") + 
    theme_classic() + 
    scale_fill_viridis_d()+ 
    theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1))
  
  ggsave(paste0("spectrum/", gsub(".vcf", "", files[i]),"ivf_spectrum.png"),
         height=3*vcfRange@sampleNames %>% unique() %>% length(),
         width=12,limitsize = F)

  write.csv(sca_mm, paste0("spectrum/", gsub(".vcf", "", files[i]), "IVF_spectrum.csv"))
  write.csv(sca_mm_count, paste0("spectrum/", gsub(".vcf", "", files[i]), "IVF_spectrum_counts.csv"))
}

setwd("spectrum/")
files<- list.files(pattern="*spectrum.csv")
theData_list<-lapply(files, read.csv)
dat <-bind_cols(theData_list)
titles <- dat$X...1
dat <- dat %>% 
  dplyr::select(-starts_with("X."))
rownames(dat) <- titles

sigs_mm <- as.matrix(dat)

write.csv(sigs_mm, "../../trinucleotide_context.csv")

####COUNTS####
files<- list.files(pattern="*spectrum_counts.csv")
theData_list<-lapply(files, read.csv)
dat <-bind_cols(theData_list)
titles <- dat$X...1
dat <- dat %>% 
  dplyr::select(-starts_with("X."))
rownames(dat) <- titles

sigs_mm <- as.matrix(dat)

sigs_mm %>% as.data.frame() %>% 
  rownames_to_column() %>%
  mutate(mutation = str_replace(rowname, 
                                "^(\\w)(\\w)\\s(\\w)\\.(\\w)$", 
                                "\\3[\\1>\\2]\\4")) %>% 
  dplyr::select(MutationType = mutation,
         everything()) %>% 
  dplyr::select(-rowname) %>% 
  write.table("../../trinucleotide_counts_by_sample.txt", sep="\t", row.names = F, quote = F)

