#!/bin/bash
#SBATCH --ntasks=1
#SBATCH --time=72:00:00
#SBATCH --mem-per-cpu=32G
#SBATCH --cpus-per-task=8

ml singularity

bcftools=$CONTDIR/bcftools_1.16.sif

input_vcf=vcf_style_dvmp.vcf

singularity exec $bcftools bcftools query -l $input_vcf | while read SAMPLE; do
    singularity exec $bcftools bcftools view -c 1 -s $SAMPLE -Oz -o ${SAMPLE}_05_08.vcf.gz $input_vcf
done
