#!/bin/bash

#SBATCH --job-name=mpileup
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=2
#SBATCH --time=200:00:00
#SBATCH --mem=200GB
#SBATCH --array=1-36

#############
# DIRECTORY
#############
SAMPLE=$(sed -n "${SLURM_ARRAY_TASK_ID}p" "sample_list.txt" | cut -d " " -f1)
REF=mm39.fa
BAM=${SAMPLE}.bam

##################################
# MPILEUP VARIANT CALLING
##################################
bcftools_v1.9-1-deb_cv1.sif \
bcftools \
mpileup \
-Ou \
-f $REF \
--regions ${CHR} $BAM | \
singularity exec bcftools_v1.9-1-deb_cv1.sif \
bcftools \
call \
-mv \
-Oz \
-o $OUT/${SAMPLE}.vcf.gz
