#!/bin/bash

#SBATCH --job-name=deepvariant
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=2
#SBATCH --time=200:00:00
#SBATCH --mem=200GB
#SBATCH --array=1-36



#############
# DIRECTORY
#############
SAMPLE=$(sed -n "${SLURM_ARRAY_TASK_ID}p" "sample_list.txt" | cut -d " " -f1)
REF=mm39.fa
BAM=${SAMPLE}.bam

##################################
# INITIAL ROUND OF VARIANT CALLER
##################################
echo "performing initial round of variant calling with deepvariant"
for CHR in $(cat chr_list.txt)
do
singularity exec deepvariant_1.2.0.sif run_deepvariant \
--model_type WGS \
--ref $REF \
--reads $BAM \
--output_vcf $WORKDIR/vcf/${SAMPLE}_chr${CHR}_DeepVar.vcf.gz \
--output_gvcf $WORKDIR/gvcf/${SAMPLE}_chr${CHR}_DeepVar.g.vcf.gz \
--num_shards 4 \
--regions chr$CHR
done
