#!/bin/bash

#SBATCH --job-name=BWA
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=2
#SBATCH --time=72:00:00
#SBATCH --mem=100GB
#SBATCH --array=1-36

##################
#Load the programs
##################
module load singularity

##############
# DIRECTORIES
##############
REF=mm39.fa
SAMPLE=$(sed -n "${SLURM_ARRAY_TASK_ID}p" "sample_list.txt" | cut -d " " -f1)
BAM=${SAMPLE}.bam

samtools flagstat $BAM
samtools idxstats $BAM
