#!/bin/bash

#SBATCH --job-name=BWA
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=2
#SBATCH --time=72:00:00
#SBATCH --mem=100GB
#SBATCH --array=1-36

##################
#Load the programs
##################
module load singularity

##############
# DIRECTORIES
##############
REF=mm39.fa
SAMPLE=$(sed -n "${SLURM_ARRAY_TASK_ID}p" "sample_list.txt" | cut -d " " -f1)

###############
# MAPPING READS
################
FASTQ1_FILE=${SAMPLE}_R1_fastq
FASTQ2_FILE=${SAMPLE}_R2_fastq

BAM_FILE=`echo $FASTQ1_FILE | sed 's/.fastq$/.bam/'`
BAM_FILE=`basename $BAM_FILE`;
BAM_FILE=$OUTPUT_DIR/$BAM_FILE

bwa mem $REF $FASTQ1_FILE $FASTQ2_FILE | samtools sort -o $BAM_FILE -

echo "job complete"


####################
# INDEX BAM
#####################
samtools index $BAM_FILE
