#!/bin/bash
#fastp.sh

#SBATCH --job-name=FastP
#SBATCH --time=72:00:00
#SBATCH --mail-type=ALL
#SBATCH --mem=100GB
#SBATCH --array=1-36

##############
# MODULE LOAD
##############
module load singularity

##############
# DIRECTORIES
################
SAMPLE=`cat sample_list.txt | sed -n "${SLURM_ARRAY_TASK_ID}p"`

############
# FASTP
#############
fastp \
--in1 $FASTQ/${SAMPLE}_R1.fastq.gz \
--in2 $FASTQ/${SAMPLE}_R2.fastq.gz \
--out1 $OUT/${SAMPLE}_R1.fastq.gz \
--out2 $OUT/${SAMPLE}_R2.fastq.gz \
--json $JSON/${SAMPLE}.json
