# ##############################################################################
# Compiler configuration
# @author Massimiliano Rossi
# ##############################################################################

# Add the basic compiler options
add_compile_options("-std=c++11")
# add_compile_options("-Werror")
add_compile_options("-Wall")
add_compile_options("-Wextra")
add_compile_options("-Wcomment")
add_compile_options("-Wdouble-promotion")
add_compile_options("-Wformat=2")
add_compile_options("-Wnonnull")
add_compile_options("-Winit-self")
add_compile_options("-Wmain")
add_compile_options("-Wmissing-braces")
add_compile_options("-Wmissing-include-dirs")
add_compile_options("-Wparentheses")
add_compile_options("-Wsequence-point")
add_compile_options("-Wreturn-local-addr")
add_compile_options("-Wreturn-type")
add_compile_options("-Wswitch")
add_compile_options("-Wswitch-default")
add_compile_options("-Wswitch-enum")
add_compile_options("-Wunused-but-set-parameter")
add_compile_options("-Wunused-but-set-variable")
add_compile_options("-Wunused-function")
add_compile_options("-Wunused-label")
add_compile_options("-Wunused-local-typedefs")
add_compile_options("-Wunused-parameter")
add_compile_options("-Wunused-variable")
add_compile_options("-Wunused-value")
add_compile_options("-Wunused")
add_compile_options("-Wuninitialized")
add_compile_options("-Wunknown-pragmas")
add_compile_options("-Wstrict-aliasing")
add_compile_options("-Wstrict-overflow=5")
add_compile_options("-Warray-bounds")
add_compile_options("-Wundef")
add_compile_options("-Wendif-labels")
add_compile_options("-Wshadow")
add_compile_options("-Wfree-nonheap-object")
add_compile_options("-Wunsafe-loop-optimizations")
add_compile_options("-Wpointer-arith")
add_compile_options("-Wtype-limits")
add_compile_options("-Wcast-qual")
add_compile_options("-Wwrite-strings")
add_compile_options("-Wclobbered")
add_compile_options("-Wconversion")
add_compile_options("-Wenum-compare")
add_compile_options("-Wsign-compare")
add_compile_options("-Wsign-conversion")
add_compile_options("-Waddress")
add_compile_options("-Wlogical-op")
add_compile_options("-Wno-aggressive-loop-optimizations")
add_compile_options("-Wattributes")
add_compile_options("-Wbuiltin-macro-redefined")
add_compile_options("-Wmissing-declarations")
add_compile_options("-Wmissing-field-initializers")
add_compile_options("-Wdeprecated")
add_compile_options("-Wdeprecated-declarations")
add_compile_options("-Woverflow")
add_compile_options("-Wpacked")
add_compile_options("-Wno-packed-bitfield-compat")
add_compile_options("-Winline")
add_compile_options("-Wint-to-pointer-cast")
add_compile_options("-Winvalid-pch")
add_compile_options("-Wno-long-long")
add_compile_options("-Wno-variadic-macros")
add_compile_options("-Wvarargs")
add_compile_options("-Wvector-operation-performance")
add_compile_options("-Wvla")
add_compile_options("-Wvolatile-register-var")
add_compile_options("-Wdisabled-optimization")
add_compile_options("-Wstack-protector")
add_compile_options("-Woverlength-strings")
add_compile_options("-fvisibility=hidden")
add_compile_options("-Wc++11-compat")
add_compile_options("-Wconversion-null")
add_compile_options("-Wuseless-cast")
add_compile_options("-Winherited-variadic-ctor")
add_compile_options("-Winvalid-offsetof")
add_compile_options("-Wvirtual-move-assign")
add_compile_options("-pedantic")
add_compile_options("-fno-gnu-keywords")
add_compile_options("-foptional-diags")
add_compile_options("-Wctor-dtor-privacy")
add_compile_options("-Wdelete-non-virtual-dtor")
add_compile_options("-Wliteral-suffix")
add_compile_options("-Wnarrowing")
add_compile_options("-Wnon-virtual-dtor")
add_compile_options("-Wreorder")
add_compile_options("-Weffc++")
add_compile_options("-fno-ext-numeric-literals")
add_compile_options("-Wnon-template-friend")
add_compile_options("-Wold-style-cast")
add_compile_options("-Wpmf-conversions")
add_compile_options("-Wsign-promo")
add_compile_options("-Wchar-subscripts")
add_compile_options("-Wno-ignored-qualifiers")
add_compile_options("-Wmaybe-uninitialized")
add_compile_options("-Wdiv-by-zero")
add_compile_options("-Wtrampolines")
add_compile_options("-Wfloat-equal")
add_compile_options("-Wcast-align")
add_compile_options("-Wempty-body")
add_compile_options("-Wsizeof-pointer-memaccess")
add_compile_options("-Wmultichar")
add_compile_options("-Wnormalized=nfc")
add_compile_options("-Wnoexcept")
add_compile_options("-Wstrict-null-sentinel")

# Add the basic compiler options for debug version
#add_compile_options($<$<CONFIG:Debug>:-ggdb3>)
set(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG} -ggdb3")

# Add the basic compiler options for release version
#add_compile_options($<$<CONFIG:Release>:-ansi -march=native -funroll-loops -O3>)
set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} -ansi -march=native -funroll-loops -O3 -DNDEBUG")
#add_definitions($<$<CONFIG:Release>:-DNDEBUG>)
# -march=native