# Get differential ATAC-seq peaks
sed 's/,/\t/g' /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/heart_vs_skmuscle_DESeq2.csv | awk 'BEGIN{OFS="\t"} $7 < 0.05' |  awk 'BEGIN{OFS="\t"} $3 > 1' | cut -f1 | sed 's/"//g' | sed 's/:/\t/g' | sed 's/-/\t/g' > /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_HeartUp.bed
sed 's/,/\t/g' /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/heart_vs_skmuscle_DESeq2.csv | awk 'BEGIN{OFS="\t"} $7 < 0.05' |  awk 'BEGIN{OFS="\t"} $3 < -1' | cut -f1 | sed 's/"//g' | sed 's/:/\t/g' | sed 's/-/\t/g' > /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_MuscleUp.bed
sed 's/,/\t/g' /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/heart_vs_liver_DESeq2.csv | awk 'BEGIN{OFS="\t"} $7 < 0.05' |  awk 'BEGIN{OFS="\t"} $3 > 1' | cut -f1 | sed 's/"//g' | sed 's/:/\t/g' | sed 's/-/\t/g' > /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_HeartUp.bed
sed 's/,/\t/g' /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/heart_vs_liver_DESeq2.csv | awk 'BEGIN{OFS="\t"} $7 < 0.05' |  awk 'BEGIN{OFS="\t"} $3 < -1' | cut -f1 | sed 's/"//g' | sed 's/:/\t/g' | sed 's/-/\t/g' > /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_LiverUp.bed
sed 's/,/\t/g' /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/skmuscle_vs_liver_DESeq2.csv | awk 'BEGIN{OFS="\t"} $7 < 0.05' |  awk 'BEGIN{OFS="\t"} $3 > 1' | cut -f1 | sed 's/"//g' | sed 's/:/\t/g' | sed 's/-/\t/g' > /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_MuscleUp.bed
sed 's/,/\t/g' /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/skmuscle_vs_liver_DESeq2.csv | awk 'BEGIN{OFS="\t"} $7 < 0.05' |  awk 'BEGIN{OFS="\t"} $3 < -1' | cut -f1 | sed 's/"//g' | sed 's/:/\t/g' | sed 's/-/\t/g' > /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_LiverUp.bed

# Get centers of differential ATAC-seq peaks +/- 250bp
# awk -vOFS="\t" -vEXT=125 'width=$3-$2 {if(width % 2 != 0) {width+=1} ; mid=$2+width/2; if(width > 2*EXT) {print $1,mid-EXT,mid+EXT} else {print $1,$2,$3} }' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_HeartUp.bed
awk -vOFS="\t" -vEXT=125 'width=$3-$2 {if(width % 2 != 0) {width+=1} ; mid=$2+width/2; if(width <= 1000) print $1,mid-EXT,mid+EXT}' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_HeartUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_HeartUp.fa
awk -vOFS="\t" -vEXT=125 'width=$3-$2 {if(width % 2 != 0) {width+=1} ; mid=$2+width/2; if(width <= 1000) print $1,mid-EXT,mid+EXT}' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_MuscleUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_MuscleUp.fa
awk -vOFS="\t" -vEXT=125 'width=$3-$2 {if(width % 2 != 0) {width+=1} ; mid=$2+width/2; if(width <= 1000) print $1,mid-EXT,mid+EXT}' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_HeartUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_HeartUp.fa
awk -vOFS="\t" -vEXT=125 'width=$3-$2 {if(width % 2 != 0) {width+=1} ; mid=$2+width/2; if(width <= 1000) mid=$2+width/2; print $1,mid-EXT,mid+EXT}' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_LiverUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_LiverUp.fa
awk -vOFS="\t" -vEXT=125 'width=$3-$2 {if(width % 2 != 0) {width+=1} ; mid=$2+width/2; if(width <= 1000) print $1,mid-EXT,mid+EXT}' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_MuscleUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_MuscleUp.fa
awk -vOFS="\t" -vEXT=125 'width=$3-$2 {if(width % 2 != 0) {width+=1} ; mid=$2+width/2; if(width <= 1000) print $1,mid-EXT,mid+EXT}' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_LiverUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_LiverUp.fa

# Get fasta files for differential peaks
awk 'BEGIN{OFS="\t"} $3-$2 <= 1000' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_HeartUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_HeartUp_fullSeq.fa
awk 'BEGIN{OFS="\t"} $3-$2 <= 1000' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_MuscleUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_MuscleUp_fullSeq.fa
awk 'BEGIN{OFS="\t"} $3-$2 <= 1000' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_HeartUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_HeartUp_fullSeq.fa
awk 'BEGIN{OFS="\t"} $3-$2 <= 1000' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_LiverUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_LiverUp_fullSeq.fa
awk 'BEGIN{OFS="\t"} $3-$2 <= 1000' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_MuscleUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_MuscleUp_fullSeq.fa
awk 'BEGIN{OFS="\t"} $3-$2 <= 1000' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_LiverUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_LiverUp_fullSeq.fa

# Get differential ATAC-seq peaks for re-processed data
sed 's/,/\t/g' /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/heart_vs_liver_DESeq2_ENCODEpip.csv | awk 'BEGIN{OFS="\t"} $7 < 0.05' |  awk 'BEGIN{OFS="\t"} $3 > 1' | cut -f1 | sed 's/"//g' | sed 's/:/\t/g' | sed 's/-/\t/g' > /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_ENCODEpip_HeartUp.bed
sed 's/,/\t/g' /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/heart_vs_liver_DESeq2_ENCODEpip.csv | awk 'BEGIN{OFS="\t"} $7 < 0.05' |  awk 'BEGIN{OFS="\t"} $3 < -1' | cut -f1 | sed 's/"//g' | sed 's/:/\t/g' | sed 's/-/\t/g' > /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_ENCODEpip_LiverUp.bed
sed 's/,/\t/g' /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/heart_vs_skmuscle_DESeq2_ENCODEpip.csv | awk 'BEGIN{OFS="\t"} $7 < 0.05' |  awk 'BEGIN{OFS="\t"} $3 > 1' | cut -f1 | sed 's/"//g' | sed 's/:/\t/g' | sed 's/-/\t/g' > /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_ENCODEpip_HeartUp.bed
sed 's/,/\t/g' /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/heart_vs_skmuscle_DESeq2_ENCODEpip.csv | awk 'BEGIN{OFS="\t"} $7 < 0.05' |  awk 'BEGIN{OFS="\t"} $3 < -1' | cut -f1 | sed 's/"//g' | sed 's/:/\t/g' | sed 's/-/\t/g' > /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_ENCODEpip_MuscleUp.bed
sed 's/,/\t/g' /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/skmuscle_vs_liver_DESeq2_ENCODEpip.csv | awk 'BEGIN{OFS="\t"} $7 < 0.05' |  awk 'BEGIN{OFS="\t"} $3 > 1' | cut -f1 | sed 's/"//g' | sed 's/:/\t/g' | sed 's/-/\t/g' > /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_ENCODEpip_MuscleUp.bed
sed 's/,/\t/g' /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/skmuscle_vs_liver_DESeq2_ENCODEpip.csv | awk 'BEGIN{OFS="\t"} $7 < 0.05' |  awk 'BEGIN{OFS="\t"} $3 < -1' | cut -f1 | sed 's/"//g' | sed 's/:/\t/g' | sed 's/-/\t/g' > /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_ENCODEpip_LiverUp.bed

# Get centers of differential ATAC-seq peaks +/- 250bp
awk -vOFS="\t" -vEXT=125 'width=$3-$2 {if(width % 2 != 0) {width+=1} ; mid=$2+width/2; if(width <= 1000) print $1,mid-EXT,mid+EXT}' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_ENCODEpip_HeartUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_ENCODEpip_HeartUp.fa
awk -vOFS="\t" -vEXT=125 'width=$3-$2 {if(width % 2 != 0) {width+=1} ; mid=$2+width/2; if(width <= 1000) print $1,mid-EXT,mid+EXT}' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_ENCODEpip_LiverUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_liver_DESeq2_ENCODEpip_LiverUp.fa
awk -vOFS="\t" -vEXT=125 'width=$3-$2 {if(width % 2 != 0) {width+=1} ; mid=$2+width/2; if(width <= 1000) print $1,mid-EXT,mid+EXT}' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_ENCODEpip_HeartUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_ENCODEpip_HeartUp.fa
awk -vOFS="\t" -vEXT=125 'width=$3-$2 {if(width % 2 != 0) {width+=1} ; mid=$2+width/2; if(width <= 1000) print $1,mid-EXT,mid+EXT}' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_ENCODEpip_MuscleUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/heart_vs_skmuscle_DESeq2_ENCODEpip_MuscleUp.fa
awk -vOFS="\t" -vEXT=125 'width=$3-$2 {if(width % 2 != 0) {width+=1} ; mid=$2+width/2; if(width <= 1000) print $1,mid-EXT,mid+EXT}' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_ENCODEpip_MuscleUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_ENCODEpip_MuscleUp.fa
awk -vOFS="\t" -vEXT=125 'width=$3-$2 {if(width % 2 != 0) {width+=1} ; mid=$2+width/2; if(width <= 1000) print $1,mid-EXT,mid+EXT}' /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_ENCODEpip_LiverUp.bed | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/skmuscle_vs_liver_DESeq2_ENCODEpip_LiverUp.fa

# Get summits of differential ATAC-seq peaks that overlap an active histone modification region +/-250bp
zcat /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/f33c25ae-864d-42c9-a74e-80cf301d3d0c/call-reproducibility_idr/execution/idr.conservative_peak.narrowPeak.gz /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/RightVentricle/atac/75055828-6c86-4521-95d5-282ee459dcf7/call-reproducibility_idr/execution/idr.conservative_peak.narrowPeak.gz | sort -u -k1,1 -k2,2n -k3,3n -k10,10n | intersectBed -wa -u -a stdin -b /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/DESEQ_filtered_CHIP/FC1/merged_files/Heart_over_skmuscle_FC1_CHIPfilter_merged.bed | awk 'BEGIN{OFS="\t"} {print $1, $2+$10-125, $2+$10+125}' | sort -u -k1,1 -k2,2n -k3,3n | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_summitPlusMinus250bp.fa
zcat /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/f33c25ae-864d-42c9-a74e-80cf301d3d0c/call-reproducibility_idr/execution/idr.conservative_peak.narrowPeak.gz /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/RightVentricle/atac/75055828-6c86-4521-95d5-282ee459dcf7/call-reproducibility_idr/execution/idr.conservative_peak.narrowPeak.gz | sort -u -k1,1 -k2,2n -k3,3n -k10,10n | intersectBed -wa -u -a stdin -b /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/DESEQ_filtered_CHIP/FC1/merged_files/Heart_over_liver_FC1_CHIPfilter_merged.bed | awk 'BEGIN{OFS="\t"} {print $1, $2+$10-125, $2+$10+125}' | sort -u -k1,1 -k2,2n -k3,3n | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_summitPlusMinus250bp.fa
intersectBed -wa -u -a /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak.narrowPeak.gz -b /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/DESEQ_filtered_CHIP/FC1/merged_files/Skmuscle_over_heart_FC1_CHIPfilter_merged.bed | awk 'BEGIN{OFS="\t"} {print $1, $2+$10-125, $2+$10+125}' | sort -u -k1,1 -k2,2n -k3,3n | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverHeartChipfilter_summitPlusMinus250bp.fa
intersectBed -wa -u -a /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak.narrowPeak.gz -b /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/DESEQ_filtered_CHIP/FC1/merged_files/Skmuscle_over_liver_FC1_CHIPfilter_merged.bed | awk 'BEGIN{OFS="\t"} {print $1, $2+$10-125, $2+$10+125}' | sort -u -k1,1 -k2,2n -k3,3n | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_summitPlusMinus250bp.fa
intersectBed -wa -u -a /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak.narrowPeak.gz -b /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/DESEQ_filtered_CHIP/FC1/merged_files/Liver_over_heart_FC1_CHIPfilter_merged.bed | awk 'BEGIN{OFS="\t"} {print $1, $2+$10-125, $2+$10+125}' | sort -u -k1,1 -k2,2n -k3,3n | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak_overlapLiverOverHeartChipfilter_summitPlusMinus250bp.fa
intersectBed -wa -u -a /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak.narrowPeak.gz -b /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/DESEQ_filtered_CHIP/FC1/merged_files/Liver_over_skmuscle_FC1_CHIPfilter_merged.bed | awk 'BEGIN{OFS="\t"} {print $1, $2+$10-125, $2+$10+125}' | sort -u -k1,1 -k2,2n -k3,3n | fastaFromBed -fi /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa -bed stdin -fo /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak_overlapLiverOverSkmuscleChipfilter_summitPlusMinus250bp.fa
zcat /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/f33c25ae-864d-42c9-a74e-80cf301d3d0c/call-reproducibility_idr/execution/idr.conservative_peak.narrowPeak.gz /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/RightVentricle/atac/75055828-6c86-4521-95d5-282ee459dcf7/call-reproducibility_idr/execution/idr.conservative_peak.narrowPeak.gz | sort -u -k1,1 -k2,2n -k3,3n -k10,10n | intersectBed -wa -u -a stdin -b /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/DESEQ_filtered_CHIP/FC1/merged_files/Heart_over_skmuscle_FC1_CHIPfilter_merged.bed | gzip > /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter.narrowPeak.gz
zcat /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/f33c25ae-864d-42c9-a74e-80cf301d3d0c/call-reproducibility_idr/execution/idr.conservative_peak.narrowPeak.gz /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/RightVentricle/atac/75055828-6c86-4521-95d5-282ee459dcf7/call-reproducibility_idr/execution/idr.conservative_peak.narrowPeak.gz | sort -u -k1,1 -k2,2n -k3,3n -k10,10n | intersectBed -wa -u -a stdin -b /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/DESEQ_filtered_CHIP/FC1/merged_files/Heart_over_liver_FC1_CHIPfilter_merged.bed | gzip > /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter.narrowPeak.gz
intersectBed -wa -u -a /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak.narrowPeak.gz -b /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/DESEQ_filtered_CHIP/FC1/merged_files/Skmuscle_over_heart_FC1_CHIPfilter_merged.bed | gzip >  /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverHeartChipfilter.narrowPeak.gz
intersectBed -wa -u -a /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak.narrowPeak.gz -b /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/DESEQ_filtered_CHIP/FC1/merged_files/Skmuscle_over_liver_FC1_CHIPfilter_merged.bed | gzip > /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter.narrowPeak.gz
intersectBed -wa -u -a /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak.narrowPeak.gz -b /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/DESEQ_filtered_CHIP/FC1/merged_files/Liver_over_heart_FC1_CHIPfilter_merged.bed | gzip > /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak_overlapLiverOverHeartChipfilter.narrowPeak.gz
intersectBed -wa -u -a /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak.narrowPeak.gz -b /hpc/group/gersbachlab/cmk90/Small_2K_Library_Design/DESEQ_filtered_CHIP/FC1/merged_files/Liver_over_skmuscle_FC1_CHIPfilter_merged.bed | gzip > /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak_overlapLiverOverSkmuscleChipfilter.narrowPeak.gz

# Do motif analysis for differential DNase peaks that overlap an active histone modification region +/- 250bp
meme-chip -o /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_summitPlusMinus250bp.MemeChipResults -db /hpc/group/gersbachlab/imk11/MotifData/motif_databases/CIS-BP_2.00/Homo_sapiens.meme -neg /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverHeartChipfilter_summitPlusMinus250bp.fa -meme-nmotifs 10 /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_summitPlusMinus250bp.fa
meme-chip -o /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_summitPlusMinus250bp.MemeChipResults -db /hpc/group/gersbachlab/imk11/MotifData/motif_databases/CIS-BP_2.00/Homo_sapiens.meme -neg /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak_overlapLiverOverHeartChipfilter_summitPlusMinus250bp.fa -meme-nmotifs 10 /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_summitPlusMinus250bp.fa
meme-chip -o /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverHeartChipfilter_summitPlusMinus250bp.MemeChipResults -db /hpc/group/gersbachlab/imk11/MotifData/motif_databases/CIS-BP_2.00/Homo_sapiens.meme -neg /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_summitPlusMinus250bp.fa -meme-nmotifs 10 /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverHeartChipfilter_summitPlusMinus250bp.fa
meme-chip -o /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_summitPlusMinus250bp.MemeChipResults -db /hpc/group/gersbachlab/imk11/MotifData/motif_databases/CIS-BP_2.00/Homo_sapiens.meme -neg /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak_overlapLiverOverSkmuscleChipfilter_summitPlusMinus250bp.fa -meme-nmotifs 10 /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_summitPlusMinus250bp.fa
ame -o /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_summitPlusMinus250bp.AmeResults --control /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverHeartChipfilter_summitPlusMinus250bp.fa /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_summitPlusMinus250bp.fa /hpc/group/gersbachlab/imk11/MotifData/motif_databases/CIS-BP_2.00/Homo_sapiens.meme
ame -o /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_summitPlusMinus250bp.AmeResults --control /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak_overlapLiverOverHeartChipfilter_summitPlusMinus250bp.fa /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_summitPlusMinus250bp.fa /hpc/group/gersbachlab/imk11/MotifData/motif_databases/CIS-BP_2.00/Homo_sapiens.meme
ame -o /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverHeartChipfilter_summitPlusMinus250bp.AmeResults --control /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_summitPlusMinus250bp.fa /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverHeartChipfilter_summitPlusMinus250bp.fa /hpc/group/gersbachlab/imk11/MotifData/motif_databases/CIS-BP_2.00/Homo_sapiens.meme
ame -o /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_summitPlusMinus250bp.AmeResults --control /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak_overlapLiverOverSkmuscleChipfilter_summitPlusMinus250bp.fa /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_summitPlusMinus250bp.fa /hpc/group/gersbachlab/imk11/MotifData/motif_databases/CIS-BP_2.00/Homo_sapiens.meme

# Prepare files for training CNN
python /hpc/home/imk11/src/RegElEvoCode/prepareDLNumpyArrays.py --positivePeakFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter.narrowPeak.gz --negativePeakFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverHeartChipfilter.narrowPeak.gz --outputFileNamePrefix /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --sequenceLength 250
python /hpc/home/imk11/src/RegElEvoCode/prepareDLNumpyArrays.py --positivePeakFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter.narrowPeak.gz --negativePeakFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak_overlapLiverOverHeartChipfilter.narrowPeak.gz --outputFileNamePrefix /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --sequenceLength 250
python /hpc/home/imk11/src/RegElEvoCode/prepareDLNumpyArrays.py --positivePeakFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter.narrowPeak.gz --negativePeakFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/Liver/atac/peak/idr_reproducibility/idr.optimal_peak_overlapLiverOverSkmuscleChipfilter.narrowPeak.gz --outputFileNamePrefix /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --sequenceLength 250

# Train heart vs. muscle, heart vs. liver, and muscle vs. liver
python /hpc/home/imk11/src/IMKHeartEnhancerScripts/trainCNNHeartVsMuscleDNaseChipfilterLowLR.py > /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR.log
# Performance:
# Training set: loss: 0.441641, accuracy: 0.812138, sensitivity: 0.806657, specificity: 0.820042, auc: 0.895952, precision: 0.866014, NPV: 0.746285, auprc: 0.866966, F1: 0.835282, recallAt0.05FDR: 0.363144, recallAt0.1FDR: 0.551742, recallAt0.2FDR: 0.753442
# Validation set: loss: 0.486319, accuracy: 0.764972, sensitivity: 0.754197, specificity: 0.782333, auc: 0.856399, precision: 0.848083, NPV: 0.663917, auprc: 0.810713, F1: 0.798389, recallAt0.05FDR: 0.252325, recallAt0.1FDR: 0.412088, recallAt0.2FDR: 0.604396
python /hpc/home/imk11/src/IMKHeartEnhancerScripts/trainCNNHeartVsLiverDNaseChipfilterLowLR.py > /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR.log
# Performance:
# Training set: loss: 0.324981, accuracy: 0.877884, sensitivity: 0.932644, specificity: 0.721763, auc: 0.918519, precision: 0.905273, NPV: 0.789849, auprc: 0.843124, F1: 0.918754, recallAt0.05FDR: 0.405237, recallAt0.1FDR: 0.550511, recallAt0.2FDR: 0.710014
# Validation set: loss: 0.338008, accuracy: 0.869106, sensitivity: 0.928362, specificity: 0.711837, auc: 0.912542, precision: 0.895292, NPV: 0.789207, auprc: 0.835771, F1: 0.911527, recallAt0.05FDR: 0.340037, recallAt0.1FDR: 0.495887, recallAt0.2FDR: 0.700411
python /hpc/home/imk11/src/IMKHeartEnhancerScripts/trainCNNMuscleVsLiverDNaseChipfilterLowLR.py > /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR.log
# Performance:
# Training set: loss: 0.418294, accuracy: 0.820754, sensitivity: 0.832478, specificity: 0.798955, auc: 0.897002, precision: 0.885037, NPV: 0.719514, auprc: 0.851391, F1: 0.857953, recallAt0.05FDR: 0.391251, recallAt0.1FDR: 0.536169, recallAt0.2FDR: 0.711521
# Validation set: loss: 0.435484, accuracy: 0.806861, sensitivity: 0.818958, specificity: 0.787801, auc: 0.884116, precision: 0.858775, NPV: 0.734169, auprc: 0.854199, F1: 0.838394, recallAt0.05FDR: 0.386132, recallAt0.1FDR: 0.546382, recallAt0.2FDR: 0.710807

# Make predictions for heart vs. muscle, heart vs. liver, and muscle vs. liver models at all tissue-specific candidate enhancers
python /hpc/home/imk11/src/OCROrthologPrediction/src/predictNewSequencesNoEvaluation.py --weightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --architectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --fastaFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_summitPlusMinus250bp.fa --sequenceLength 250 --predictedProbaFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_predictedProbaHeartVsSkmuscle.txt --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --classification
python /hpc/home/imk11/src/OCROrthologPrediction/src/predictNewSequencesNoEvaluation.py --weightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --architectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --fastaFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverHeartChipfilter_summitPlusMinus250bp.fa --sequenceLength 250 --predictedProbaFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverHeartChipfilter_predictedProbaHeartVsSkmuscle.txt --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --classification
python /hpc/home/imk11/src/OCROrthologPrediction/src/predictNewSequencesNoEvaluation.py --weightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --architectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --fastaFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_summitPlusMinus250bp.fa --sequenceLength 250 --predictedProbaFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_predictedProbaHeartVsLiver.txt --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --classification
python /hpc/home/imk11/src/OCROrthologPrediction/src/predictNewSequencesNoEvaluation.py --weightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --architectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --fastaFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_summitPlusMinus250bp.fa --sequenceLength 250 --predictedProbaFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_predictedProbaLiverVsSkmuscle.txt  --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --classification

# Make predictions for heart vs. muscle, heart vs. liver, and muscle vs. liver models at MPRA sequences
python /hpc/home/imk11/src/OCROrthologPrediction/src/predictNewSequencesNoEvaluation.py --weightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --architectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --fastaFileName /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/Combination_Library_Sequences.fa --sequenceLength 250 --predictedProbaFileName /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/Combination_Library_Sequences_predictedProbaHeartVsSkmuscle.txt --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --classification
python /hpc/home/imk11/src/OCROrthologPrediction/src/predictNewSequencesNoEvaluation.py --weightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --architectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --fastaFileName /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/Combination_Library_Sequences.fa --sequenceLength 250 --predictedProbaFileName /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/Combination_Library_Sequences_predictedProbaHeartVsLiver.txt --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --classification
python /hpc/home/imk11/src/OCROrthologPrediction/src/predictNewSequencesNoEvaluation.py --weightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --architectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --fastaFileName /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/Combination_Library_Sequences.fa --sequenceLength 250 --predictedProbaFileName /hpc/group/gersbachlab/imk11/HeartMuscleLiverMPRA/Combination_Library_Sequences_predictedProbaLiverVsSkmuscle.txt  --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --classification

# Interpret heart vs. muscle, heart vs. liver, and muscle vs. liver models for the validation set
python /hpc/home/imk11/src/enhancer_prediction_code/featureSelector/deepLIFFT/Applied/ireneHistoneMod/getDeepLIFTScores.py --modelWeightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --modelArchitectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr8 --chroms chr9 --genomicsDefaultRule --getHypotheticalContribs --hdf5Output --includeIncorrect --codePath /hpc/home/imk11/src --scoreTrackPrefix HeartVsMuscle_deepLIFTScores --outputFileNamePrefix /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR --genomeName hg38
python /hpc/home/imk11/src/enhancer_prediction_code/featureSelector/deepLIFFT/Applied/ireneHistoneMod/getDeepLIFTScores.py --modelWeightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --modelArchitectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr8 --chroms chr9 --genomicsDefaultRule --getHypotheticalContribs --hdf5Output --includeIncorrect --codePath /hpc/home/imk11/src --scoreTrackPrefix HeartVsLiver_deepLIFTScores --outputFileNamePrefix /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR --genomeName hg38
python /hpc/home/imk11/src/enhancer_prediction_code/featureSelector/deepLIFFT/Applied/ireneHistoneMod/getDeepLIFTScores.py --modelWeightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --modelArchitectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr8 --chroms chr9 --genomicsDefaultRule --getHypotheticalContribs --hdf5Output --includeIncorrect --codePath /hpc/home/imk11/src --scoreTrackPrefix MuscleVsLiver_deepLIFTScores --outputFileNamePrefix /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR --genomeName hg38
python /hpc/home/imk11/src/CTCFMutants/runNewTFModisco.py --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr8 --chroms chr9 --deepLiftScoresFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_deepLIFTScores.h5 --TFModiscoResultsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_TFModiscoResults.h5 --codePath /hpc/home/imk11/src
python /hpc/home/imk11/src/CTCFMutants/runNewTFModisco.py --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr8 --chroms chr9 --deepLiftScoresFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR_deepLIFTScores.h5 --TFModiscoResultsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR_TFModiscoResults.h5 --codePath /hpc/home/imk11/src
python /hpc/home/imk11/src/CTCFMutants/runNewTFModisco.py --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr8 --chroms chr9 --deepLiftScoresFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_deepLIFTScores.h5 --TFModiscoResultsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_TFModiscoResults.h5 --codePath /hpc/home/imk11/src

# Interpret heart vs. muscle, heart vs. liver, and muscle vs. liver models for the training and validation sets
python /hpc/home/imk11/src/enhancer_prediction_code/featureSelector/deepLIFFT/Applied/ireneHistoneMod/getDeepLIFTScores.py --modelWeightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --modelArchitectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr3 --chroms chr4 --chroms chr5 --chroms chr6 --chroms chr7 --chroms chr10 --chroms chr11 --chroms chr12 --chroms chr13 --chroms chr14 --chroms chr15 --chroms chr16 --chroms chr17 --chroms chr18 --chroms chr19 --chroms chr20 --chroms chr21 --chroms chr22 --chroms chrX --chroms chr8 --chroms chr9 --genomicsDefaultRule --getHypotheticalContribs --hdf5Output --includeIncorrect --codePath /hpc/home/imk11/src --scoreTrackPrefix HeartVsMuscle_deepLIFTScores --outputFileNamePrefix /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_trainAndValid --genomeName hg38
python /hpc/home/imk11/src/enhancer_prediction_code/featureSelector/deepLIFFT/Applied/ireneHistoneMod/getDeepLIFTScores.py --modelWeightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --modelArchitectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr3 --chroms chr4 --chroms chr5 --chroms chr6 --chroms chr7 --chroms chr10 --chroms chr11 --chroms chr12 --chroms chr13 --chroms chr14 --chroms chr15 --chroms chr16 --chroms chr17 --chroms chr18 --chroms chr19 --chroms chr20 --chroms chr21 --chroms chr22 --chroms chrX --chroms chr8 --chroms chr9 --genomicsDefaultRule --getHypotheticalContribs --hdf5Output --includeIncorrect --codePath /hpc/home/imk11/src --scoreTrackPrefix HeartVsLiver_deepLIFTScores --outputFileNamePrefix /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR_trainAndValid --genomeName hg38
python /hpc/home/imk11/src/enhancer_prediction_code/featureSelector/deepLIFFT/Applied/ireneHistoneMod/getDeepLIFTScores.py --modelWeightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --modelArchitectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr3 --chroms chr4 --chroms chr5 --chroms chr6 --chroms chr7 --chroms chr10 --chroms chr11 --chroms chr12 --chroms chr13 --chroms chr14 --chroms chr15 --chroms chr16 --chroms chr17 --chroms chr18 --chroms chr19 --chroms chr20 --chroms chr21 --chroms chr22 --chroms chrX --chroms chr8 --chroms chr9 --genomicsDefaultRule --getHypotheticalContribs --hdf5Output --includeIncorrect --codePath /hpc/home/imk11/src --scoreTrackPrefix MuscleVsLiver_deepLIFTScores --outputFileNamePrefix /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_trainAndValid --genomeName hg38
python /hpc/home/imk11/src/CTCFMutants/runNewTFModisco.py --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr3 --chroms chr4 --chroms chr5 --chroms chr6 --chroms chr7 --chroms chr10 --chroms chr11 --chroms chr12 --chroms chr13 --chroms chr14 --chroms chr15 --chroms chr16 --chroms chr17 --chroms chr18 --chroms chr19 --chroms chr20 --chroms chr21 --chroms chr22 --chroms chrX --chroms chr8 --chroms chr9 --deepLiftScoresFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_trainAndValid_deepLIFTScores.h5 --TFModiscoResultsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_TFModiscoResults_trainAndValid.h5 --codePath /hpc/home/imk11/src
python /hpc/home/imk11/src/CTCFMutants/runNewTFModisco.py --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr3 --chroms chr4 --chroms chr5 --chroms chr6 --chroms chr7 --chroms chr10 --chroms chr11 --chroms chr12 --chroms chr13 --chroms chr14 --chroms chr15 --chroms chr16 --chroms chr17 --chroms chr18 --chroms chr19 --chroms chr20 --chroms chr21 --chroms chr22 --chroms chrX --chroms chr8 --chroms chr9 --deepLiftScoresFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_trainAndValid_deepLIFTScores.h5 --TFModiscoResultsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_NewestTFModiscoResults_trainAndValid.h5 --codePath /hpc/home/imk11/src
#python /hpc/home/imk11/src/CTCFMutants/runNewTFModisco.py --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr3 --chroms chr4 --chroms chr5 --chroms chr6 --chroms chr7 --chroms chr10 --chroms chr11 --chroms chr12 --chroms chr13 --chroms chr14 --chroms chr15 --chroms chr16 --chroms chr17 --chroms chr18 --chroms chr19 --chroms chr20 --chroms chr21 --chroms chr22 --chroms chrX --chroms chr8 --chroms chr9 --deepLiftScoresFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR_trainAndValid_deepLIFTScores.h5 --TFModiscoResultsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR_TFModiscoResults_trainAndValid.h5 --codePath /hpc/home/imk11/src
#python /hpc/home/imk11/src/CTCFMutants/runNewTFModisco.py --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr3 --chroms chr4 --chroms chr5 --chroms chr6 --chroms chr7 --chroms chr10 --chroms chr11 --chroms chr12 --chroms chr13 --chroms chr14 --chroms chr15 --chroms chr16 --chroms chr17 --chroms chr18 --chroms chr19 --chroms chr20 --chroms chr21 --chroms chr22 --chroms chrX --chroms chr8 --chroms chr9 --deepLiftScoresFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_trainAndValid_deepLIFTScores.h5 --TFModiscoResultsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_TFModiscoResults_trainAndValid.h5 --codePath /hpc/home/imk11/src

# Interpret heart vs. muscle, heart vs. liver, and muscle vs. liver models for the entire genome
python /hpc/home/imk11/src/enhancer_prediction_code/featureSelector/deepLIFFT/Applied/ireneHistoneMod/getDeepLIFTScores.py --modelWeightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --modelArchitectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr3 --chroms chr4 --chroms chr5 --chroms chr6 --chroms chr7 --chroms chr10 --chroms chr11 --chroms chr12 --chroms chr13 --chroms chr14 --chroms chr15 --chroms chr16 --chroms chr17 --chroms chr18 --chroms chr19 --chroms chr20 --chroms chr21 --chroms chr22 --chroms chrX --chroms chr8 --chroms chr9 --chroms chr1 --chroms chr2 --genomicsDefaultRule --codePath /hpc/group/gersbachlab/imk11/UCSCUtils --deeplearningCodePath /hpc/home/imk11/src --scoreTrackPrefix HeartVsMuscle_deepLIFTScores --outputFileNamePrefix /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverSkmuscleChipfilter_vsSkeletalMuscleOverHeartChipfilter_data_train.KerasModels/heartMuscleChipfilter_250bp_conv3SmallBatchLowLR_all --genomeName hg38
python /hpc/home/imk11/src/enhancer_prediction_code/featureSelector/deepLIFFT/Applied/ireneHistoneMod/getDeepLIFTScores.py --modelWeightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --modelArchitectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr3 --chroms chr4 --chroms chr5 --chroms chr6 --chroms chr7 --chroms chr10 --chroms chr11 --chroms chr12 --chroms chr13 --chroms chr14 --chroms chr15 --chroms chr16 --chroms chr17 --chroms chr18 --chroms chr19 --chroms chr20 --chroms chr21 --chroms chr22 --chroms chrX --chroms chr8 --chroms chr9 --genomicsDefaultRule --chroms chr1 --chroms chr2 --codePath /hpc/group/gersbachlab/imk11/UCSCUtils --deeplearningCodePath /hpc/home/imk11/src --scoreTrackPrefix HeartVsLiver_deepLIFTScores --outputFileNamePrefix /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/LeftVentricle/atac/peak/idr_reproducibility/idr.conservative_peak_orRightVentricle_overlapHeartOverLiverChipfilter_vsLiverOverHeartChipfilter_data_train.KerasModels/heartLiverChipfilter_250bp_conv3SmallBatchLowLR_all --genomeName hg38
python /hpc/home/imk11/src/enhancer_prediction_code/featureSelector/deepLIFFT/Applied/ireneHistoneMod/getDeepLIFTScores.py --modelWeightsFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR.hdf5 --modelArchitectureFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_architecture.json --sequenceLength 250 --peakInfoFileName /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter.narrowPeak.gz --genomeFileName /hpc/group/gersbachlab/imk11/sei-framework/resources/hg38_UCSC.fa --chroms chr3 --chroms chr4 --chroms chr5 --chroms chr6 --chroms chr7 --chroms chr10 --chroms chr11 --chroms chr12 --chroms chr13 --chroms chr14 --chroms chr15 --chroms chr16 --chroms chr17 --chroms chr18 --chroms chr19 --chroms chr20 --chroms chr21 --chroms chr22 --chroms chrX --chroms chr8 --chroms chr9 --genomicsDefaultRule --chroms chr1 --chroms chr2 --codePath /hpc/group/gersbachlab/imk11/UCSCUtils --deeplearningCodePath /hpc/home/imk11/src --scoreTrackPrefix MuscleVsLiver_deepLIFTScores --outputFileNamePrefix /hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.KerasModels/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_all --genomeName hg38
