import sys
import numpy as np
np.random.seed(1701)

kerasDir = "/hpc/group/gersbachlab/imk11/miniconda3/envs/IMKMinicondaEnv/lib/python3.10/site-packages/keras/"
sys.path.insert(0,kerasDir)
codeDir = "/hpc/home/imk11/src/"
sys.path.insert(0,codeDir)
from deeplearning.rSeqDNN import rSeqDNN

sys.setrecursionlimit(10000);

def run():
	# Setup parameters for experiment
	# Data parameters
	trainDataFileName =\
	    "/hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_train.npy"
	trainLabelsFileName =\
		"/hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_labels_train.npy"
	validDataFileName =\
		"/hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_data_valid.npy"
	validLabelsFileName =\
		"/hpc/group/gersbachlab/imk11/ENCODEHumanDNase/SkeletalMuscle_GoodReps/atac/1ca08417-8cba-4986-b5f4-25ca8bf202e7/call-reproducibility_idr/execution/idr.optimal_peak_overlapSkmuscleOverLiverChipfilter_vsLiverOverSkeletalMuscleChipfilter_labels_valid.npy"
	createModelDir = False;
	multiMode = False;
	# Architecture parameters
	imShape = (1,4,250);
	convSizeList = [(4,6),(1,6),(1,6)];
	numFiltList = [150,150,150];
	l1WRegList = [0.0001 for i in range(len(numFiltList))];
	poolSize = (1,6);
	poolStride = (1,6);
	intermediatePool = False;
	denseSizeList = [];
	rnnSizeList = [];
	fcSize = 45;
	drop=0.2;
	rnnType = "GRU";
	batchNorm = False;
	# Training parameters
	mode = "binary";
	numEpochs = 3;
	learningRate = 0.0005;
	batchSize=100;
	verbose = 1;
	h5FileName = "muscleLiverChipfilter_250bp_conv3SmallBatchLowLR";
	optimizerType = "SGD";
	momentum=0.99;
	nesterov=True;
	rho = 0.95;
	classWeightBySize = True;
	trainPredictFileName =\
		"muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_trainPredictions";
	testPredictFileName =\
		"muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_validPredictions";
	crossValFold = None;
	useModelDir = True;
	# Pre-training balanced parameters
	pretrainBal = False;
	bh5FileName =\
		"muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_balanced";
	# Pre-training extreme parameters
	pretrainExtreme = False;
	# External pre-training parameters
	pretrainExternal = False;
	externalWtFileName = "";
	externalArFileName = "";
	layersToPretrain = [];
	# Start experiment
	hybrid = rSeqDNN(codeDir=codeDir+"deeplearning/");
	hybrid.loadDataFromNumpyArrays(trainDataFileName, trainLabelsFileName, imShape, createModelDir=createModelDir, trainingSet=True)
	hybrid.loadDataFromNumpyArrays(validDataFileName, validLabelsFileName, imShape, createModelDir=False, trainingSet=False)
	model =\
		hybrid.buildFullyConnectedHybrid(convSizeList, numFiltList, l1WRegList, poolSize, poolStride, rnnSizeList, fcSize, drop, mode, 
			batchNorm=batchNorm, intermediatePool=intermediatePool, denseSizeList=denseSizeList);
	[model, bestEvaluationMetric] =\
		hybrid.trainHybrid(model, mode, numEpochs, learningRate, batchSize, verbose, h5FileName, optimizerType,	testPredictFileName, pretrainExternal, \
			trainPredictFileName=trainPredictFileName, pretrainBal=pretrainBal, momentum=momentum, nesterov=nesterov, classWeightBySize=classWeightBySize, \
			crossValFold=crossValFold, useModelDir=useModelDir, externalWtFileName=externalWtFileName, externalArFileName=externalArFileName, \
			layersToPretrain=layersToPretrain);
	# Save architecture to json file
	json_string = model.to_json();
	open(hybrid.modelDir + "/muscleLiverChipfilter_250bp_conv3SmallBatchLowLR_architecture.json","w").write(json_string);
	
if __name__ == '__main__':
	run();
