# Divide files into training, validaiton, and test sets
grep -P 'chr3|chr4|chr5|chr6|chr7|chr9|chr11|chr12|chr13|chr14|chr15|chr16|chr17|chr18|chr19|chrX' /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen.bed | fastaFromBed -fi /hpc/home/imk11/HeartEnhancerProject/HumanGenome/hg38.fa -bed stdin -fo /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa
grep -P 'chr3|chr4|chr5|chr6|chr7|chr9|chr11|chr12|chr13|chr14|chr15|chr16|chr17|chr18|chr19|chrX' /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed.bed | fastaFromBed -fi /hpc/home/imk11/HeartEnhancerProject/HumanGenome/hg38.fa -bed stdin -fo /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa
grep -P 'chr8|chr10' /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen.bed | fastaFromBed -fi /hpc/home/imk11/HeartEnhancerProject/HumanGenome/hg38.fa -bed stdin -fo /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa
grep -P 'chr8|chr10' /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed.bed | fastaFromBed -fi /hpc/home/imk11/HeartEnhancerProject/HumanGenome/hg38.fa -bed stdin -fo /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa

# ls-gkm, default parameters -- overfitting
/hpc/home/imk11/src/lsgkm/bin/gkmtrain /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmdefault
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmdefault.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmdefault.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmdefault.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmdefault.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmdefault.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmdefault.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmdefault.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmdefault.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 1.0, NPV: 0.99832775919, F1: 0.9983277591
# Validation set -- sensitivity: 0.91954022988, specificity: 0.79710144927, NPV: 0.88709677419, F1: 0.83969465648

# ls-gkm, c=0.7 -- more overfitting
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -c 0.7 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.7
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.7.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.7.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.7.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.7.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.7.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.7.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.7.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.7.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 0.98827470686, NPV: 0.99830795262, F1: 0.99326599326
# Validation set -- sensitivity: 0.89655172413, specificity: 0.7536231884, NPV: 0.85245901639, F1: 0.79999999999

# ls-gkm, c=0.5 -- more overfitting
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -c 0.5 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.5
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.5.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.5.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.5.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.5.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.5.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.5.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.5.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmc.5.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 0.96314907872, NPV: 0.99826388888, F1: 0.98039215685
# Validation set -- sensitivity: 0.80459770114, specificity: 0.7536231884, NPV: 0.7536231884, F1: 0.7536231884

#ls-gkm, t=3 -- more overfitting
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 3 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt3
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt3.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt3.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt3.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt3.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt3.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt3.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt3.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt3.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 0.98492462311, NPV: 0.99830220713, F1: 0.99156829679
# Validation set -- sensitivity: 0.80459770114, specificity: 0.73913043478, NPV: 0.75, F1: 0.74452554744

#ls-gkm, t=2 -- overfitting
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 1.0, NPV: 0.99832775919, F1: 0.99916317991
# Validation set -- sensitivity: 0.91954022988, specificity: 0.79710144927, NPV: 0.88709677419, F1: 0.83969465648

##ls-gkm, t=2, l=10 -- overfitting a little
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 10 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 0.99832495812, NPV: 0.99832495812, F1: 0.99832495812
# Validation set -- sensitivity: 0.93103448275, specificity: 0.79710144927, NPV: 0.90163934426, F1: 0.84615384615

##ls-gkm, t=2, l=10, k=6 -- almost almost best
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 10 -k 6 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 0.98994974874, NPV: 0.99831081081, F1: 0.99411269974
# Validation set -- sensitivity: 0.91954022988, specificity: 0.84057971014, NPV: 0.8923076923, F1: 0.86567164179

##ls-gkm, t=2, l=10, k=5 -- almost almost best
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 10 -k 5 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99390243902, specificity: 0.9715242881, NPV: 0.99315068493, F1: 0.98221845892
# Validation set -- sensitivity: 0.93103448275, specificity: 0.85507246376, NPV: 0.90769230769, F1: 0.88059701492

##ls-gkm, t=2, l=10, k=5, d=4 -- almost almost best
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 10 -k 5 -d 4 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d4
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d4.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d4.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d4.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d4.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d4.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d4.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d4.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d4.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99237804878, specificity: 0.96649916247, NPV: 0.9914089347, F1: 0.97879558947
# Validation set -- sensitivity: 0.94252873563, specificity: 0.82608695652, NPV: 0.91935483871, F1: 0.82608695652

##ls-gkm, t=2, l=10, k=5, d=2 -- almost best
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 10 -k 5 -d 2 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d2
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d2.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d2.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d2.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d2.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d2.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d2.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d2.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5d2.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99695121951, specificity: 0.99162479062, NPV: 0.99663299663, F1: 0.99412258606
# Validation set -- sensitivity: 0.90804597701, specificity: 0.84057971014, NPV: 0.87878787878, F1: 0.85925925925

##ls-gkm, t=2, l=10, k=5, w=0.9 -- best
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 10 -k 5 -w 0.9 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99237804878, specificity: 0.9715242881, NPV: 0.99145299145, F1: 0.98138747884
# Validation set -- sensitivity: 0.93103448275, specificity: 0.88405797101, NPV: 0.91044776119, F1: 0.89705882352

##ls-gkm, t=2, l=10, k=5, w=0.8
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 10 -k 5 -w 0.8 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.8
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.8.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.8.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.8.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.8.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.8.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.8.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.8.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.8.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99237804878, specificity: 0.97822445561, NPV: 0.99151103565, F1: 0.98482293423
# Validation set -- sensitivity: 0.89655172413, specificity: 0.88405797101, NPV: 0.87142857142, F1: 0.87769784172

##ls-gkm, t=2, l=10, k=5, w=0.9, s -- best
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 10 -k 5 -w 0.9 -s /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9s
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9s.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9s.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9s.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9s.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9s.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9s.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9s.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5w.9s.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99237804878, specificity: 0.9715242881, NPV: 0.99145299145, F1: 0.98138747884
# Validation set -- sensitivity: 0.93103448275, specificity: 0.88405797101, NPV: 0.91044776119, F1: 0.89705882352

##ls-gkm, t=2, l=10, k=4 -- overfitting a little
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 10 -k 4 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k4
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k4.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k4.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k4.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k4.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k4.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k4.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k4.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k4.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.98323170731, specificity: 0.93299832495, NPV: 0.98063380281, F1: 0.95622317595
# Validation set -- sensitivity: 0.91954022988, specificity: 0.81159420289, NPV: 0.88888888888, F1: 0.84848484847

##ls-gkm, t=2, l=10, k=5, e = 0.0001 -- almost almost best
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 10 -k 5 -e 0.0001 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.0001
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.0001.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.0001.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.0001.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.0001.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.0001.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.0001.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.0001.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.0001.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99390243902, specificity: 0.9715242881, NPV: 0.99315068493, F1: 0.98221845892
# Validation set -- sensitivity: 0.93103448275, specificity: 0.85507246376, NPV: 0.90769230769, F1: 0.88059701492

##ls-gkm, t=2, l=10, k=5, e = 0.01 -- almost almost best
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 10 -k 5 -e 0.01 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.01
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.01.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.01.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.01.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.01.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.01.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.01.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.01.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k5e.01.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99390243902, specificity: 0.9715242881, NPV: 0.99315068493, F1: 0.98221845892
# Validation set -- sensitivity: 0.93103448275, specificity: 0.85507246376, NPV: 0.90769230769, F1: 0.88059701492

##ls-gkm, t=2, l=10, k=6, e = 0.005 -- almost almost best
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 10 -k 6 -e 0.005 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6e.005
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6e.005.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6e.005.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6e.005.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6e.005.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6e.005.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6e.005.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6e.005.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10k6e.005.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 0.98994974874, NPV: 0.99831081081, F1: 0.99411269974
# Validation set -- sensitivity: 0.91954022988, specificity: 0.84057971014, NPV: 0.8923076923, F1: 0.86567164179

##ls-gkm, t=2, l=9, k=6 -- almost best
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 9 -k 6 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l9k6
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l9k6.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l9k6.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l9k6.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l9k6.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l9k6.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l9k6.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l9k6.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l9k6.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 0.99329983249, NPV: 0.99831649831, F1: 0.99580184718
# Validation set -- sensitivity: 0.93103448275, specificity: 0.82608695652, NPV: 0.90476190476, F1: 0.86363636363

#ls-gkm, t=2, c=0.95 -- overfitting
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -c 0.95 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.95
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.95.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.95.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.95.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.95.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.95.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.95.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.95.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.95.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 0.99832495812, NPV: 0.99832495812, F1: 0.99832495812
# Validation set -- sensitivity: 0.91954022988, specificity: 0.79710144927, NPV: 0.88709677419, F1: 0.83969465648

#ls-gkm, t=2, c=0.9 -- overfitting a little
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -c 0.9 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.9
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.9.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.9.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.9.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.9.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.9.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.9.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.9.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.9.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 0.99832495812, NPV: 0.99832495812, F1: 0.99832495812
# Validation set -- sensitivity: 0.93103448275, specificity: 0.79710144927, NPV: 0.90163934426, F1: 0.84615384615

#ls-gkm, t=2, l=10, c=0.9 -- best
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -l 10 -c 0.9 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10c.9
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10c.9.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10c.9.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10c.9.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10c.9.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10c.9.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10c.9.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10c.9.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2l10c.9.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 0.99664991624, NPV: 0.99832214765, F1: 0.99748533109
# Validation set -- sensitivity: 0.91954022988, specificity: 0.79710144927, NPV: 0.88709677419, F1: 0.83969465648

#ls-gkm, t=2, c=0.8 -- more overfitting
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 2 -c 0.8 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.8
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.8.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.8.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.8.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.8.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.8.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.8.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.8.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt2c.8.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 0.99664991624, NPV: 0.99832214765, F1: 0.99748533109
# Validation set -- sensitivity: 0.93103448275, specificity: 0.78260869565, NPV: 0.9, F1: 0.83720930232

#ls-gkm, t=1 -- a lot more overfitting
/hpc/home/imk11/src/lsgkm/bin/gkmtrain -t 1 /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt1
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt1.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt1.trainPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_train.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt1.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt1.trainNegPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIROpen_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt1.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt1.validPosPredictions.txt
/hpc/home/imk11/src/lsgkm/bin/gkmpredict /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/CHIRClosed_valid.fa /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt1.model.txt /hpc/home/imk11/HeartEnhancerProject/CHIRAtac/SVMOutputs/CHIROpenVsClosed_lsgkmt1.validNegPredictions.txt
# Performance:
# Training set -- sensitivity: 0.99847560975, specificity: 1.0, NPV: 0.99832775919, F1: 0.99916317991
# Validation set -- sensitivity: 0.68965517241, specificity: 0.36231884058, NPV: 0.48076923076, F1: 0.41322314049
