% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoreMeth2Plot.r
\name{PoreMeth2Plot}
\alias{PoreMeth2Plot}
\title{Function for plotting DMRs, Entropy levels and Gene Annotations}
\usage{
PoreMeth2Plot(
  Input = NA,
  AnnotatedRes,
  PoreMeth2DMRResults,
  Meth1,
  Meth2,
  CGI = TRUE,
  DNAse = TRUE,
  Enhancers = TRUE,
  TFBS = TRUE,
  CpGPositions = FALSE,
  AddRange = "auto",
  CoefLM = 0.3,
  Assembly = "hg19",
  Palette = "Pal12",
  TxtGeneColor = "black",
  DMRBeta = TRUE,
  DMREntropy = FALSE,
  DMRBetaPoly = FALSE,
  DMRPoints = TRUE,
  DMRLines = FALSE,
  FeatureLines = FALSE,
  FeaturePoints = FALSE,
  DMREntropyPoly = FALSE,
  EntropyPoints = TRUE,
  Grid = TRUE,
  CoordLines = TRUE,
  ShowCpGNames = FALSE,
  DMRLinesW = 1,
  DMRLinesT = 1,
  PointsCex = 0.5,
  FeatureLinesW = 1,
  FeatureLinesT = 2,
  FeatureLinesC1 = NULL,
  FeatureLinesC2 = NULL,
  FeaturePointsC = NULL,
  GeneNameOffset = 0
)
}
\arguments{
\item{Input}{Either a string character of coordinates to plot (chr:start-end) or gene symbol}

\item{AnnotatedRes}{Annotated results from PoreMeth2. Data.frame}

\item{PoreMeth2DMRResults}{Poremeth results}

\item{Meth1}{Output from perl parser. Data.frame, chr, pos, entropy, number of reads for entropy estimation, beta level, number of reads for beta levels estimation}

\item{Meth2}{Output from perl parser. Data.frame, chr, pos, entropy, number of reads for entropy estimation, beta level, number of reads for beta levels estimation}

\item{CGI}{Shows CpG Islands. TRUE or FALSE. Default TRUE}

\item{DNAse}{Shows DNAse sites. TRUE or FALSE. Default TRUE}

\item{Enhancers}{Shows Enhancers sites. TRUE or FALSE. Default TRUE}

\item{TFBS}{Shows TFBS sites. TRUE or FALSE. Default TRUE}

\item{CpGPositions}{Shows CpGPositions sites. TRUE or FALSE.  Default FALSE}

\item{AddRange}{Zoom out from input coordinates/gene. Can be "auto" or an integer. Default "auto"}

\item{CoefLM}{Coeficient for polynomial regression for beta and entropy levels. Numeric value. Default 0.3}

\item{Assembly}{Reference annotation to use. Can be "hg19" or "hg38". Default "hg19"}

\item{Palette}{Palette colors to use. Can be "Pal1" to "Pal12", otherwhise a custom color vector can be used (length > 5). Default = "Pal12".}

\item{TxtGeneColor}{Color for gene symbols. May improve readibility. Default "black"}

\item{DMRBeta}{Shows delta beta levels. TRUE or FALSE. Default TRUE}

\item{DMREntropy}{Shows delta entropy levels. TRUE or FALSE. Default TRUE}

\item{DMRBetaPoly}{Shows polynomial regression line of beta levels for test and control. TRUE or FALSE. Default TRUE}

\item{DMRPoints}{Shows the delta betas for each CpG on which DMRs are calculated. TRUE or FALSE. Default FALSE}

\item{DMRLines}{Shows raw lines linking the points on which DMRs are calculated. TRUE or FALSE. Default FALSE}

\item{FeatureLines}{As DMRLines but in a different plot. TRUE or FALSE, Default = FALSE}

\item{FeaturePoints}{As DMRPoints but in a different plot. TRUE or FALSE, Default = FALSE}

\item{DMREntropyPoly}{Shows polynomial regression line for entropy levels for test and control. TRUE or FALSE. Default TRUE}

\item{EntropyPoints}{Shows the delta entropy for each CpG on which DMRs are calculated. TRUE or FALSE. Default FALSE}

\item{Grid}{Shows horizontal lines for better value estimation. TRUE or FALSE, Default FALSE}

\item{CoordLines}{Shows vertical lines for DMRs. It helps to compare plots. Default = TRUE}

\item{ShowCpGNames}{Shows GpG IDs. TRUE or FALSE, Default FALSE}

\item{DMRLinesW}{Line width for DMREntropyPoly. Default 1}

\item{DMRLinesT}{Line type for DMREntropyPoly. Default 1}

\item{PointsCex}{Cex for test Points. Default 0.5}

\item{FeatureLinesW}{Line width for FeatureLines. Default 1}

\item{FeatureLinesT}{Line type for FeatureLines. Default 2}

\item{GeneNameOffset}{Offset on X axis of the gene names. Use in case the gene name ovelaps gene models. Default = 0.}
}
\value{
Plot(s)
}
\description{
This function plot the results from PoreMeth2. It presents various parameters for plot customization.
}
