% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoreMeth2DMRStatistics.r
\name{PoreMeth2DMRStatistics}
\alias{PoreMeth2DMRStatistics}
\title{Summarize Results}
\usage{
PoreMeth2DMRStatistics(
  TableInDMR,
  Assembly = "hg19",
  BetaThr = 0.2,
  EntropyThr = 0.1,
  PValueThr = 0.05,
  AnalysisClass = "All"
)
}
\arguments{
\item{TableInDMR}{Is the output from \code{PoreMeth2DMR}, data.frame.}

\item{Assembly}{Optional parameter that specifies the reference version to use for statistics (\code{"hg19"} or \code{"hg38"}), character.}

\item{BetaThr}{Delta beta threshold applied for DMRs' classification, numeric.}

\item{EntropyThr}{Delta S threshold applied for DMRs' classification, numeric.}

\item{PValueThr}{The p.value threshold to consider a DMR, numeric.}

\item{AnalysisClass}{define the summary to return ("All", "Beta", "Entropy"). Default = "All", character.}
}
\value{
data.frame with Summarized Results.
}
\description{
Returns a summary of hyper/hypo-methylated regions with different values of Delta S across different genic features, CpG Islands and enhancers.
}
