% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoreMeth2DMR.r
\name{PoreMeth2DMR}
\alias{PoreMeth2DMR}
\title{Function for DMR, Beta and Entropy Detection}
\usage{
PoreMeth2DMR(TableTest, TableControl, omega = 0.1, eta = 1e-05, FW = 3)
}
\arguments{
\item{TableTest}{Output from parse_nanopolish_entropy.pl, data.frame.}

\item{TableControl}{Output from parse_nanopolish_entropy.pl, data.frame.}

\item{omega}{Optional parameter that modulates the relative weight between the experimental and the biological variance. When omega is close to 1, the biological variance is much larger than the experimental one, while for values of omega close to 0 the experimental noise gives the leading contribution to the total variance. We suggest to use \code{omega} in the range 0.1-0.5, numeric.}

\item{eta}{Optional parameter that represents the baseline probability the mean process (m_i) changes its value for the HSLM algorithm. Suggested values are inside 10^{-7}-10^{−3} range, numeric.}

\item{FW}{The minimum number of datapoints for a DMR to be called (DMRs made of a number of CpGs smaller than \code{FW} are discarded), numeric.}
}
\value{
data.frame with identified DMR with corresponding Beta and Entropy values for each detected range.
}
\description{
Performs the double segmentation of Beta and S to identify DMRs and calculate Delta\Beta and Delta S between test and control sample.
}
