% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoreMeth1DMR.r
\name{PoreMeth1DMR}
\alias{PoreMeth1DMR}
\title{Function to identify DMR}
\usage{
PoreMeth1DMR(
  TableTest,
  TableControl,
  omega = 0.1,
  eta = 1e-05,
  stepeta = 1e+06,
  FW = 3
)
}
\arguments{
\item{TableTest}{Output from parse_nanopolish_entropy.pl, data.frame.}

\item{TableControl}{Output from parse_nanopolish_entropy.pl, data.frame.}

\item{omega}{Optional parameter that modulates the relative weight between the experimental and the biological variance. When omega is close to 1, the biological variance is much larger than the experimental one, while for values of omega close to 0 the experimental noise gives the leading contribution to the total variance. We suggest to use \code{omega} in the range 0.1-0.5, numeric.}

\item{eta}{Optional parameter that represents the baseline probability the mean process (m_i) changes its value for the HSLM algorithm. Suggested values are inside 10^{-7}-10^{−3} range, numeric.}

\item{stepeta}{Distance normalization parameter. A value between 1e-4 1e-6, numeric.}

\item{FW}{The minimum number of datapoints for a DMR to be called (DMRs made of a number of CpGs smaller than \code{FW} are discarded), numeric.}
}
\value{
data.frame with identified DMR.
}
\description{
In case read-level methylation calls are not available and entropy cannot be calculated, it is possible to identify DMRs based strictly on beta shifts between samples.
}
