/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.watcher;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class WatcherLog {
    private transient PrintWriter pw = null;
    private String filename = null;

    public WatcherLog(MARTiEngineOptions options) {
    }

    public synchronized void open(String f, boolean clearLogs) {
        if (clearLogs) {
            this.filename = f + ".log";
        } else {
            SimpleDateFormat df = new SimpleDateFormat("ddMMyy_HHmmss");
            Date dateobj = new Date();
            this.filename = f + "_" + df.format(dateobj).toString() + ".log";
        }
        System.out.println("Opening " + this.filename);
        try {
            this.pw = new PrintWriter(new FileWriter(this.filename, true));
        }
        catch (IOException e) {
            System.out.println("WatcherLog exception");
            e.printStackTrace();
        }
    }

    public synchronized void close() {
        if (this.pw != null) {
            this.pw.close();
        }
    }

    public synchronized void print(String s) {
        if (this.pw != null) {
            this.pw.print(s);
            this.pw.flush();
        }
    }

    public synchronized void println(String s) {
        if (this.pw != null) {
            this.pw.println(s);
            this.pw.flush();
        }
    }

    public synchronized PrintWriter getPrintWriter() {
        return this.pw;
    }
}

