/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.watcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.MARTiProgress;
import uk.ac.earlham.marti.watcher.FilePair;
import uk.ac.earlham.marti.watcher.FileWatcherItem;

public class FileWatcher {
    private MARTiEngineOptions options;
    private int filesToProcess = 0;
    private int filesProcessed = 0;
    private int lastCompleted = -1;
    private long lastFileTime = System.nanoTime();
    private long secsSinceLast = 0L;
    private boolean useProgressBar = false;
    private ArrayList<FileWatcherItem> batchContainersToWatch = new ArrayList();
    private ArrayList<FileWatcherItem> fileDirsToWatch = new ArrayList();
    private Hashtable<String, Integer> batchDirs = new Hashtable();
    private Hashtable<String, Integer> allFiles = new Hashtable();
    private LinkedList<FileWatcherItem> pendingFiles = new LinkedList();
    private MARTiProgress progressReport = null;

    public FileWatcher(MARTiEngineOptions o, MARTiProgress pr) {
        this.options = o;
        this.progressReport = pr;
    }

    public void addBatchContainer(String d, int pf) {
        this.options.getLog().println("Added batch dir: " + d);
        this.batchContainersToWatch.add(new FileWatcherItem(d, pf));
    }

    public void addWatchDir(String d) {
        this.options.getLog().println("Added watch dir: " + d);
        this.fileDirsToWatch.add(new FileWatcherItem(d, 1));
    }

    public synchronized void addPendingFile(String s, int pf) {
        this.pendingFiles.add(new FileWatcherItem(s, pf));
        this.progressReport.incrementRawFileCount(s);
        ++this.filesToProcess;
    }

    public synchronized FileWatcherItem getPendingFile() {
        if (this.pendingFiles.size() > 0) {
            ++this.filesProcessed;
            return this.pendingFiles.removeFirst();
        }
        return null;
    }

    public void writeProgress() {
        long e = 0L;
        long s = 50L;
        if (this.useProgressBar) {
            if (this.filesToProcess > 0) {
                e = 50 * this.filesProcessed / this.filesToProcess;
                s = 50L - e;
            }
            System.out.print("\rProcessing [");
            int i = 0;
            while ((long)i < e) {
                System.out.print("=");
                ++i;
            }
            i = 0;
            while ((long)i < s) {
                System.out.print(" ");
                ++i;
            }
            System.out.print("] " + this.filesProcessed + "/" + this.filesToProcess);
            this.lastCompleted = this.filesProcessed;
        } else {
            System.out.println("Processed " + this.filesProcessed + "/" + this.filesToProcess);
        }
    }

    private File[] getTimeSortedFileList(File d) {
        File[] files = d.listFiles();
        if (files == null) {
            this.options.getLog().println("Directory " + d.getPath() + " doesn't exist");
            System.out.println("Directory " + d.getPath() + " doesn't exist");
        } else if (files.length <= 0) {
            this.options.getLog().println("Directory " + d.getPath() + " empty");
        } else {
            int i;
            Object[] pairs = new FilePair[files.length];
            for (i = 0; i < files.length; ++i) {
                pairs[i] = new FilePair(files[i]);
            }
            Arrays.sort(pairs);
            for (i = 0; i < files.length; ++i) {
                files[i] = ((FilePair)pairs[i]).f;
            }
        }
        return files;
    }

    public void scan() {
        int count = 0;
        for (int i = 0; i < this.fileDirsToWatch.size(); ++i) {
            FileWatcherItem dir = this.fileDirsToWatch.get(i);
            String dirName = dir.getPathname();
            this.options.getLog().println("Scanning " + dirName);
            File d = new File(dirName);
            if (d.exists()) {
                File[] listOfFiles = this.getTimeSortedFileList(d);
                if (listOfFiles == null) {
                    this.options.getLog().println("Directory " + dirName + " doesn't exist");
                    System.out.println("Directory " + dirName + " doesn't exist");
                    continue;
                }
                if (listOfFiles.length <= 0) {
                    this.options.getLog().println("Directory " + dirName + " empty");
                    continue;
                }
                for (File file : listOfFiles) {
                    if (!file.isFile() || file.getName().startsWith(".") || this.allFiles.containsKey(file.getPath())) continue;
                    this.options.getLog().println("Got file " + file.getPath());
                    this.allFiles.put(file.getPath(), 1);
                    this.addPendingFile(file.getPath(), dir.getPassOrFail());
                    if (++count != 1) continue;
                    this.options.writeStartedFlag();
                }
                continue;
            }
            this.options.getLog().println("Directory " + dirName + " doesn't exist");
        }
        this.options.getLog().println(3, "Found " + count + " new files.");
        if (count == 0) {
            long timeSince = System.nanoTime() - this.lastFileTime;
            this.secsSinceLast = timeSince / 1000000000L;
            this.options.getLog().println(3, "Not seen file for " + this.secsSinceLast + "s");
        } else {
            this.lastFileTime = System.nanoTime();
        }
    }

    public long getSecsSinceLastFile() {
        return this.secsSinceLast;
    }

    public int getPendingFiles() {
        return this.pendingFiles.size();
    }

    public boolean timedOut() {
        this.options.getLog().println(3, "In FileWatcher timedOut: size = " + this.pendingFiles.size() + " time = " + this.secsSinceLast + " timeout = " + this.options.getFileWatcherTimeout());
        return this.pendingFiles.size() == 0 && this.secsSinceLast >= (long)this.options.getFileWatcherTimeout();
    }
}

