/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.schedule;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.MARTiLog;
import uk.ac.earlham.marti.schedule.SlurmScheduler;

public class SlurmSchedulerJob {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_PENDING = 1;
    public static final int STATE_RUNNING = 2;
    public static final int STATE_COMPLETED = 3;
    public static final int STATE_BOOT_FAIL = 4;
    public static final int STATE_CANCELLED = 5;
    public static final int STATE_DEADLINE = 6;
    public static final int STATE_FAILED = 7;
    public static final int STATE_NODE_FAIL = 8;
    public static final int STATE_OOM = 9;
    public static final int STATE_PREEMPTED = 10;
    public static final int STATE_REQUEUED = 11;
    public static final int STATE_RESIZING = 12;
    public static final int STATE_REVOKED = 13;
    public static final int STATE_SUSPENDED = 14;
    public static final int STATE_TIMEOUT = 15;
    private MARTiEngineOptions options;
    private MARTiLog schedulerLog;
    private MARTiLog slurmLog;
    private String[] commands;
    private Process process = null;
    private String logFilename;
    private String errorFilename = null;
    private int internalJobId;
    private ArrayList<Integer> dependencies = new ArrayList();
    private boolean dontRunCommand = false;
    private int nCPUs = 2;
    private int nTasks = 1;
    private int nNodes = 1;
    private String dependencyString = "";
    private String jobName = "";
    private String maxTimeString = "6-23:00";
    private String memory = "4G";
    private String partition = "ei-medium";
    private String dependentFilename = null;
    private String flagFilename = null;
    private boolean flagStatus = false;
    private long submittedJobId = 0L;
    private int jobState = 0;
    private long completedTime = 0L;
    private long dependentTime = 0L;
    private long schedulerFileWriteDelay = 30000L;
    private long schedulerFileTimeout = 600000L;
    private int resubmissionAttempts = 0;
    private String identifier = "UNKNOWN";

    public SlurmSchedulerJob(MARTiEngineOptions o, String id, String name, int i, String[] c, String l, boolean d) {
        this.options = o;
        this.identifier = id;
        this.jobName = name;
        this.internalJobId = i;
        this.commands = c;
        this.logFilename = l;
        this.dontRunCommand = d;
        this.schedulerLog = this.options.getJobScheduler().getSchedulerLog();
        SlurmScheduler ss = (SlurmScheduler)this.options.getJobScheduler();
        this.slurmLog = ss.getSlurmLog();
    }

    public void setSchedulerFileTimeout(int l) {
        this.schedulerFileTimeout = l;
    }

    public void setSchedulerFileWriteDelay(int d) {
        this.schedulerFileWriteDelay = d;
    }

    public void setResubmissionAttempts(int n) {
        this.resubmissionAttempts = n;
    }

    public void setDependentFilename(String f) {
        this.dependentFilename = f;
        this.flagFilename = f + ".completed";
    }

    public void setJobId(int i) {
        this.internalJobId = i;
    }

    public void run() {
        File f;
        if (this.flagFilename != null && (f = new File(this.flagFilename)).exists()) {
            this.schedulerLog.println("Removing flag file " + this.flagFilename);
            f.delete();
        }
        if (this.options.continueFromPrevious()) {
            if (this.options.getProgressReport().checkCompleted(this.identifier)) {
                this.options.getLog().printlnLogAndScreen("Job " + this.identifier + " already completed, so not rerunning.");
                this.dontRunCommand = true;
            } else {
                this.options.getLog().println("Job " + this.identifier + " not completed, so will be submitting.");
            }
        }
        if (this.dontRunCommand) {
            System.out.println("Not running command for job " + this.internalJobId);
            this.submittedJobId = this.internalJobId;
            return;
        }
        Object commandString = "";
        for (int i = 0; i < this.commands.length; ++i) {
            if (this.commands[i].length() <= 0) continue;
            if (((String)commandString).length() > 0) {
                commandString = (String)commandString + " ";
            }
            commandString = (String)commandString + this.commands[i];
        }
        if (this.flagFilename != null) {
            commandString = (String)commandString + " ; touch " + this.flagFilename;
        }
        Object wrapString = "echo 'SLURM job output' ; ";
        wrapString = (String)wrapString + "echo '' ; ";
        wrapString = (String)wrapString + "echo 'Command: " + (String)commandString + "' ; ";
        wrapString = (String)wrapString + "echo 'Job ID: ${SLURM_JOB_ID}' ; ";
        wrapString = (String)wrapString + "echo -n 'Start time: ' ; date ; ";
        wrapString = (String)wrapString + "echo -n 'Machine: ' ; hostname ; ";
        wrapString = (String)wrapString + "printf '%0.s-' {1..70} ; echo '' ; echo ''; ";
        wrapString = (String)wrapString + (String)commandString;
        wrapString = (String)wrapString + " ; echo '' ; echo '' ; printf '%0.s-' {1..70} ; ";
        wrapString = (String)wrapString + "echo '' ; echo '' ; ";
        wrapString = (String)wrapString + "sstat -j ${SLURM_JOB_ID}.batch ; ";
        wrapString = (String)wrapString + "echo '' ; echo 'SLURM ended'; ";
        wrapString = (String)wrapString + "echo -n 'End time: ' ; date";
        ArrayList<String> pbCommands = new ArrayList<String>();
        pbCommands.add("slurmit");
        pbCommands.add("-J");
        pbCommands.add(this.jobName);
        if (this.dependencyString != "") {
            pbCommands.add("-a");
            pbCommands.add(this.dependencyString);
        }
        pbCommands.add("-c");
        pbCommands.add(Integer.toString(this.nCPUs));
        pbCommands.add("-m");
        pbCommands.add(this.memory);
        pbCommands.add("-o");
        pbCommands.add(this.logFilename);
        pbCommands.add("-p");
        pbCommands.add(this.partition);
        pbCommands.add((String)commandString);
        this.schedulerLog.println("Command being run... " + (String)commandString);
        this.schedulerLog.println("CPUs: " + this.nCPUs + " Memory: " + this.memory + " Partition: " + this.partition);
        this.slurmLog.println("Job " + this.internalJobId + " command " + (String)commandString);
        Object fullCommand = "";
        for (int i = 0; i < pbCommands.size(); ++i) {
            if (i > 0) {
                fullCommand = (String)fullCommand + " ";
            }
            fullCommand = (String)fullCommand + (String)pbCommands.get(i);
        }
        if (this.nCPUs == 0) {
            this.schedulerLog.println("ERROR: nCPUs not defined for SLURM job!");
            System.out.println("Error: nCPUs not defined for SLURM job!");
            System.exit(1);
        }
        if (this.memory == null) {
            this.schedulerLog.println("ERROR: memory not defined for SLURM job!");
            System.out.println("Error: memory not defined for SLURM job!");
            System.exit(1);
        }
        if (this.partition == null) {
            this.schedulerLog.println("ERROR: partition not defined for SLURM job!");
            System.out.println("Error: partition not defined for SLURM job!");
            System.exit(1);
        }
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(pbCommands);
            this.process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("Submitted batch job")) continue;
                String id = line.substring(20);
                this.submittedJobId = Long.parseLong(id);
            }
            this.slurmLog.println("Job " + this.internalJobId + " SLURM id " + this.submittedJobId);
            reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println("Error line: " + line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public long getSubmittedJobId() {
        return this.submittedJobId;
    }

    public boolean hasFinished() {
        if (this.dontRunCommand) {
            return true;
        }
        return !this.process.isAlive();
    }

    public int getExitValue() {
        int e = 0;
        if (this.process != null && this.process.exitValue() != 3) {
            e = this.process.exitValue();
        }
        return e;
    }

    public String getCommand() {
        Object command = "";
        for (int i = 0; i < this.commands.length; ++i) {
            if (i > 0) {
                command = (String)command + " ";
            }
            command = (String)command + this.commands[i];
        }
        return command;
    }

    public int getId() {
        return this.internalJobId;
    }

    public String getLog() {
        return this.logFilename;
    }

    public void addDependency(int jobid) {
        this.dependencies.add(jobid);
    }

    public int getNumberOfDependencies() {
        return this.dependencies.size();
    }

    public int getDependency(int n) {
        if (n < this.dependencies.size()) {
            return this.dependencies.get(n);
        }
        return 0;
    }

    private void parseJobState(String stateString) {
        if (stateString.startsWith("OUT_OF_ME")) {
            this.jobState = 9;
        } else {
            switch (stateString) {
                case "BOOT_FAIL": {
                    this.jobState = 4;
                    break;
                }
                case "CANCELLED": {
                    this.jobState = 5;
                    break;
                }
                case "CANCELLED+": {
                    this.jobState = 5;
                    break;
                }
                case "COMPLETED": {
                    this.jobState = 3;
                    break;
                }
                case "DEADLINE": {
                    this.jobState = 6;
                    break;
                }
                case "FAILED": {
                    this.jobState = 7;
                    break;
                }
                case "NODE_FAIL": {
                    this.jobState = 8;
                    break;
                }
                case "OUT_OF_MEMORY": {
                    this.jobState = 9;
                    break;
                }
                case "PENDING": {
                    this.jobState = 1;
                    break;
                }
                case "PREEMPTED": {
                    this.jobState = 10;
                    break;
                }
                case "RUNNING": {
                    this.jobState = 2;
                    break;
                }
                case "REQUEUED": {
                    this.jobState = 11;
                    break;
                }
                case "RESIZING": {
                    this.jobState = 12;
                    break;
                }
                case "REVOKED": {
                    this.jobState = 13;
                    break;
                }
                case "SUSPENDED": {
                    this.jobState = 14;
                    break;
                }
                case "TIMEOUT": {
                    this.jobState = 15;
                    break;
                }
                default: {
                    this.jobState = 0;
                }
            }
        }
        this.slurmLog.println("Job " + this.internalJobId + " state parsed " + this.jobState);
    }

    public int getJobState() {
        this.slurmLog.println("Job " + this.internalJobId + " state returned " + this.jobState);
        return this.jobState;
    }

    public String getJobStateString() {
        String stateString = "UNKNOWN";
        switch (this.jobState) {
            case 4: {
                stateString = "BOOT FAIL";
                break;
            }
            case 5: {
                stateString = "CANCELLED";
                break;
            }
            case 3: {
                stateString = "COMPLETED";
                break;
            }
            case 6: {
                stateString = "DEADLINE";
                break;
            }
            case 7: {
                stateString = "FAILED";
                break;
            }
            case 8: {
                stateString = "NODE FAIL";
                break;
            }
            case 9: {
                stateString = "OOM";
                break;
            }
            case 1: {
                stateString = "PENDING";
                break;
            }
            case 10: {
                stateString = "PREEMPTED";
                break;
            }
            case 2: {
                stateString = "RUNNING";
                break;
            }
            case 11: {
                stateString = "REQUEUED";
                break;
            }
            case 12: {
                stateString = "RESIZING";
                break;
            }
            case 13: {
                stateString = "REVOKED";
                break;
            }
            case 14: {
                stateString = "SUSPENDED";
                break;
            }
            case 15: {
                stateString = "TIMEOUT";
                break;
            }
            default: {
                stateString = "UNKNOWN";
            }
        }
        return stateString;
    }

    public void queryJobState() {
        if (this.dontRunCommand) {
            this.jobState = 3;
            return;
        }
        if (this.submittedJobId > 0L) {
            try {
                String line;
                String command = "sacct -j " + this.submittedJobId + " -b -X";
                Process process = Runtime.getRuntime().exec(command);
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                this.slurmLog.println("Job " + this.internalJobId + " running " + command);
                while ((line = reader.readLine()) != null) {
                    String[] fields = line.trim().split("\\s+");
                    if (fields[0].compareTo(Long.toString(this.submittedJobId)) == 0) {
                        this.slurmLog.println("Job " + this.internalJobId + "      GOT " + line);
                        String state = fields[1];
                        this.parseJobState(state);
                        if (this.jobState != 0) continue;
                        this.schedulerLog.println("Error: couldn't parse sacct state '" + state + "'");
                        continue;
                    }
                    this.slurmLog.println("Job " + this.internalJobId + " IGNORING " + line);
                }
                if (this.jobState == 3) {
                    if (this.completedTime == 0L) {
                        this.slurmLog.println("Job " + this.internalJobId + " marked as COMPLETED by SLURM");
                        this.completedTime = System.nanoTime();
                    }
                    if (this.dependentFilename != null) {
                        long timeDiff;
                        File dependentFile = new File(this.dependentFilename);
                        File flagFile = new File(this.flagFilename);
                        if (dependentFile.exists()) {
                            if (this.dependentTime == 0L) {
                                this.slurmLog.println("Job " + this.internalJobId + " got dependent file");
                                this.dependentTime = System.nanoTime();
                                if (this.schedulerFileWriteDelay > 0L) {
                                    this.jobState = 2;
                                }
                            } else {
                                timeDiff = (System.nanoTime() - this.dependentTime) / 1000000L;
                                if (timeDiff >= this.schedulerFileWriteDelay) {
                                    this.slurmLog.println("Job " + this.internalJobId + " completed write delay");
                                    if (flagFile.exists()) {
                                        this.slurmLog.println("Job " + this.internalJobId + " got flag filename and deleting");
                                        this.flagStatus = true;
                                        flagFile.delete();
                                    }
                                } else {
                                    this.slurmLog.println("Job " + this.internalJobId + " waiting for writes");
                                    this.jobState = 2;
                                }
                            }
                        } else {
                            timeDiff = (System.nanoTime() - this.completedTime) / 1000000L;
                            this.slurmLog.println("Warning: Job " + this.internalJobId + " can't see dependent file " + timeDiff + " ms after COMPLETED.");
                            if (flagFile.exists()) {
                                this.slurmLog.println("Job " + this.internalJobId + " flag file exists");
                            } else {
                                this.slurmLog.println("Job " + this.internalJobId + " flag file missing");
                            }
                            if (timeDiff > this.schedulerFileTimeout) {
                                this.jobState = 7;
                                this.slurmLog.printlnLogAndScreen("Error: Job " + this.internalJobId + " marked as FAILED.");
                            } else {
                                this.jobState = 2;
                                this.slurmLog.println("Warning: Job " + this.internalJobId + " marked as PENDING.");
                            }
                        }
                    }
                    if (this.jobState == 3) {
                        this.options.getProgressReport().recordCompleted(this.identifier);
                    }
                }
                reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((line = reader.readLine()) != null) {
                    System.out.println("Error line: " + line);
                }
                if (this.jobState == 7 || this.jobState == 4 || this.jobState == 5 || this.jobState == 6 || this.jobState == 7 || this.jobState == 8 || this.jobState == 9 || this.jobState == 15) {
                    this.schedulerLog.printlnLogAndScreen("Job " + this.internalJobId + " (" + this.submittedJobId + ") failed with state " + this.jobState + " " + this.getJobStateString());
                    this.tryResubmission();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            System.out.println("Job not submitted");
        }
    }

    public boolean checkJobFailed() {
        boolean failed = false;
        if (this.resubmissionAttempts == 0 && (this.jobState == 7 || this.jobState == 4 || this.jobState == 5 || this.jobState == 6 || this.jobState == 7 || this.jobState == 8 || this.jobState == 9 || this.jobState == 15)) {
            this.schedulerLog.println("Job " + this.internalJobId + " (" + this.submittedJobId + ") failed with state " + this.jobState + " " + this.getJobStateString());
            failed = true;
        }
        return failed;
    }

    public void setMemory(String m) {
        this.memory = m;
    }

    public void setCPUs(int n) {
        this.nCPUs = n;
    }

    public void setQueue(String s) {
        this.partition = s;
    }

    public boolean tryResubmission() {
        boolean resubmitted = false;
        if (this.resubmissionAttempts > 0) {
            this.schedulerLog.println("Job " + this.internalJobId + " (" + this.submittedJobId + ") resubmitting.");
            this.jobState = 0;
            this.run();
            --this.resubmissionAttempts;
            resubmitted = true;
        } else {
            this.schedulerLog.println("Job " + this.internalJobId + " (" + this.submittedJobId + ") failed. No resubmission attempts remaining.");
        }
        return resubmitted;
    }
}

