/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.schedule;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.MARTiLog;
import uk.ac.earlham.marti.schedule.JobScheduler;
import uk.ac.earlham.marti.schedule.SlurmSchedulerJob;

public class SlurmScheduler
implements JobScheduler {
    private static final int MAX_QUICK_JOB_ID = 100000;
    private ConcurrentHashMap<Integer, SlurmSchedulerJob> allJobs = new ConcurrentHashMap();
    private LinkedBlockingDeque<SlurmSchedulerJob> pendingJobs = new LinkedBlockingDeque();
    private ConcurrentHashMap<Integer, SlurmSchedulerJob> runningJobs = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, SlurmSchedulerJob> failedJobs = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, Integer> jobStatus = new ConcurrentHashMap();
    private MARTiLog schedulerLog = new MARTiLog();
    private MARTiLog slurmLog = new MARTiLog();
    private MARTiEngineOptions options;
    private int internalJobId = 1;
    private int maxJobs = 1000;
    private boolean dontRunCommand = false;
    private long lastSlurmQuery = System.nanoTime();

    public SlurmScheduler(MARTiEngineOptions o) {
        this.options = o;
        this.schedulerLog.open(o.getLogsDir() + File.separator + "scheduler.txt");
        this.schedulerLog.println("maxJobs = " + this.maxJobs);
        this.slurmLog.open(o.getLogsDir() + File.separator + "slurm.txt");
    }

    @Override
    public synchronized void setDontRunCommand() {
        this.dontRunCommand = true;
    }

    @Override
    public synchronized void setMaxJobs(int m) {
        this.maxJobs = m;
        this.schedulerLog.println("maxJobs = " + this.maxJobs);
    }

    @Override
    public synchronized int submitJob(String jobPrefix, String uniqueIdentifier, String[] commands, String logFilename, boolean submitJob) {
        boolean dontRunIt = false;
        if (this.dontRunCommand || !submitJob) {
            dontRunIt = true;
        }
        SlurmSchedulerJob j = new SlurmSchedulerJob(this.options, uniqueIdentifier, jobPrefix + this.internalJobId, this.internalJobId, commands, logFilename, dontRunIt);
        j.setSchedulerFileTimeout(this.options.getSchedulerFileTimeout());
        j.setSchedulerFileWriteDelay(this.options.getSchedulerFileWriteDelay());
        j.setResubmissionAttempts(this.options.getSchedulerResubmissionAttempts());
        this.pendingJobs.add(j);
        this.allJobs.put(this.internalJobId, j);
        this.jobStatus.put(this.internalJobId, 1);
        this.schedulerLog.println("Submitted job\t" + this.internalJobId + "\t" + j.getCommand());
        return this.internalJobId++;
    }

    public synchronized void setJobMemory(int i, String s) {
        SlurmSchedulerJob ssj = this.allJobs.get(i);
        if (ssj != null) {
            ssj.setMemory(s);
        }
    }

    public synchronized void setCPUs(int i, int n) {
        SlurmSchedulerJob ssj = this.allJobs.get(i);
        if (ssj != null) {
            ssj.setCPUs(n);
        }
    }

    public synchronized void setQueue(int i, String q) {
        SlurmSchedulerJob ssj = this.allJobs.get(i);
        if (ssj != null) {
            ssj.setQueue(q);
        }
    }

    @Override
    public synchronized boolean checkJobCompleted(int i) {
        if (this.jobStatus.containsKey(i)) {
            int s = this.jobStatus.get(i);
            if (s == 3) {
                return true;
            }
        } else {
            this.options.getLog().printlnLogAndScreen("Warning: Attempt to check completion on unknown job id " + i);
        }
        return false;
    }

    @Override
    public synchronized boolean checkJobFailed(int i) {
        boolean failed = false;
        if (!this.jobStatus.containsKey(i)) {
            this.options.getLog().printlnLogAndScreen("Warning: Attempt to check completion on unknown job id " + i);
        }
        return failed;
    }

    public synchronized int getSlurmState(int i) {
        if (this.jobStatus.containsKey(i)) {
            return this.jobStatus.get(i);
        }
        this.options.getLog().printlnLogAndScreen("Warning: Attempt to check exit on unknown job id " + i);
        return 0;
    }

    @Override
    public synchronized int getExitValue(int i) {
        SlurmSchedulerJob ssj = this.allJobs.get(i);
        if (ssj != null) {
            return ssj.getExitValue();
        }
        return 0;
    }

    public synchronized void setDependentFilename(int i, String s) {
        SlurmSchedulerJob ssj = this.allJobs.get(i);
        if (ssj != null) {
            ssj.setDependentFilename(s);
        }
    }

    @Override
    public synchronized int getRunningJobCount() {
        return this.runningJobs.size();
    }

    @Override
    public synchronized int getPendingJobCount() {
        return this.pendingJobs.size();
    }

    @Override
    public synchronized void manageQueue(boolean abortWhenPendingJobsCompleted) {
        long timeNow = System.nanoTime();
        long timeDiff = (timeNow - this.lastSlurmQuery) / 1000000L;
        if (timeDiff < 60000L) {
            return;
        }
        this.lastSlurmQuery = timeNow;
        Set runningJobInternalIds = this.runningJobs.keySet();
        Iterator iterator = runningJobInternalIds.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            SlurmSchedulerJob ssj = this.runningJobs.get(id);
            ssj.queryJobState();
            int jState = ssj.getJobState();
            if (jState == 3) {
                this.schedulerLog.println("Finished job\t" + ssj.getId() + "\t" + ssj.getCommand());
                this.schedulerLog.println("Exit value was " + ssj.getExitValue());
                this.runningJobs.remove(id);
                this.jobStatus.put(id, jState);
                continue;
            }
            if (jState == 7 || jState == 4 || jState == 5 || jState == 8 || jState == 9 || jState == 13 || jState == 15) {
                this.schedulerLog.println("Job " + ssj.getId() + " failed with code " + jState + " and exit value " + ssj.getExitValue());
                this.runningJobs.remove(id);
                this.failedJobs.put(id, ssj);
                this.options.getLog().printlnLogAndScreen("Failed SLURM job " + ssj.getId() + " - see scheduler log");
                this.options.getLog().printlnLogAndScreen("Log is at " + ssj.getLog());
                continue;
            }
            if (jState == 2 || jState == 1) continue;
            this.schedulerLog.println("Unknown state for job " + ssj.getId() + " " + jState);
        }
        if (!abortWhenPendingJobsCompleted) {
            boolean foundJobToRun = true;
            while (this.runningJobs.size() < this.maxJobs && this.pendingJobs.size() > 0) {
                SlurmSchedulerJob ssj = this.pendingJobs.removeFirst();
                this.schedulerLog.println("Running job\t" + ssj.getId() + "\t" + ssj.getCommand());
                ssj.run();
                this.runningJobs.put(ssj.getId(), ssj);
                this.schedulerLog.println("SLURM id for job " + ssj.getId() + " is " + ssj.getSubmittedJobId());
            }
        }
    }

    @Override
    public synchronized int getFailedJobCount() {
        return this.failedJobs.size();
    }

    @Override
    public synchronized void markJobAsFailed(int i) {
        SlurmSchedulerJob ssj = this.allJobs.get(i);
        if (ssj != null) {
            if (this.runningJobs.containsKey(i)) {
                this.runningJobs.remove(i);
            }
            this.failedJobs.put(i, ssj);
        }
    }

    @Override
    public synchronized void resubmitJobIfPossible(int i) {
        SlurmSchedulerJob ssj = this.allJobs.get(i);
        if (ssj != null) {
            ssj.tryResubmission();
        }
    }

    @Override
    public MARTiLog getSchedulerLog() {
        return this.schedulerLog;
    }

    public MARTiLog getSlurmLog() {
        return this.slurmLog;
    }
}

