/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.schedule;

import java.io.File;
import java.util.ArrayList;
import uk.ac.earlham.marti.core.MARTiAlert;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.MARTiLog;

public class SimpleJobSchedulerJob {
    private MARTiEngineOptions options;
    private String[] commands;
    private Process process = null;
    private String logFilename;
    private String errorFilename = null;
    private int jobId;
    private ArrayList<Integer> dependencies = new ArrayList();
    private boolean dontRunCommand = false;
    private boolean completed = false;
    private String identifier = "UNKNOWN";
    private MARTiLog schedulerLog;
    private long lastStatusReport = System.nanoTime();
    private long processStartTime = System.nanoTime();

    public SimpleJobSchedulerJob(MARTiEngineOptions o, MARTiLog log, String id, String[] c, String l, boolean d) {
        this.options = o;
        this.schedulerLog = log;
        this.identifier = id;
        this.jobId = -1;
        this.commands = c;
        this.logFilename = l;
        this.dontRunCommand = d;
    }

    public SimpleJobSchedulerJob(MARTiEngineOptions o, MARTiLog log, String id, int i, String[] c, String l, boolean d) {
        this.options = o;
        this.schedulerLog = log;
        this.identifier = id;
        this.jobId = i;
        this.commands = c;
        this.logFilename = l;
        this.dontRunCommand = d;
    }

    public SimpleJobSchedulerJob(MARTiEngineOptions o, MARTiLog log, String id, int i, String[] c, String l, String e, boolean d) {
        this.options = o;
        this.schedulerLog = log;
        this.identifier = id;
        this.jobId = i;
        this.commands = c;
        this.logFilename = l;
        this.errorFilename = e;
        this.dontRunCommand = d;
    }

    public void setJobId(int i) {
        this.jobId = i;
    }

    public void run() {
        if (this.options.continueFromPrevious()) {
            if (this.options.getProgressReport().checkCompleted(this.identifier)) {
                this.options.getLog().printlnLogAndScreen("Job " + this.identifier + " already completed, so not rerunning.");
                this.dontRunCommand = true;
                return;
            }
            this.options.getLog().println("Job " + this.identifier + " not completed, so will be submitting.");
        }
        this.processStartTime = System.nanoTime();
        if (this.dontRunCommand) {
            String[] newCommands = new String[]{"sleep", "10"};
            Object logText = "[ Running ";
            for (int i = 0; i < this.commands.length; ++i) {
                logText = (String)logText + this.commands[i] + " ";
            }
            this.options.getLog().println((String)logText);
            this.commands = newCommands;
            return;
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(this.commands);
            if (this.errorFilename == null) {
                pb.redirectErrorStream(true);
            } else {
                pb.redirectErrorStream(false);
                pb.redirectError(new File(this.errorFilename));
            }
            pb.redirectOutput(ProcessBuilder.Redirect.appendTo(new File(this.logFilename)));
            this.process = pb.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public boolean hasFinished() {
        long timeNow;
        long timeSinceReport;
        boolean processFinished = false;
        if (this.dontRunCommand) {
            processFinished = true;
        } else {
            boolean bl = processFinished = !this.process.isAlive();
        }
        if (!processFinished && (timeSinceReport = ((timeNow = System.nanoTime()) - this.lastStatusReport) / 1000000000L) >= 300L) {
            long timeSinceStart = (timeNow - this.processStartTime) / 1000000000L;
            long timeMins = timeSinceStart / 60L;
            this.schedulerLog.println("Job " + this.jobId + " still running after " + timeSinceStart + "s (" + timeMins + "m)");
            this.lastStatusReport = timeNow;
        }
        if (processFinished && !this.completed) {
            if (this.getExitValue() == 0) {
                this.completed = true;
                this.options.getProgressReport().recordCompleted(this.identifier);
                this.options.getLog().println("hasFinished " + this.identifier);
            } else {
                this.options.getLog().printlnLogAndScreen("ERROR: getExitValue for job " + this.jobId + " (" + this.identifier + ") is " + this.getExitValue());
                this.options.getLog().printlnLogAndScreen("Results are unpredictable...");
                this.options.addAlertOnlyOnce(new MARTiAlert(3, "ERROR: getExitValue for job " + this.jobId + " (" + this.identifier + ") is " + this.getExitValue() + " - results are unpredictable"));
            }
        }
        return processFinished;
    }

    public int getExitValue() {
        if (this.process != null) {
            return this.process.exitValue();
        }
        return 0;
    }

    public String getCommand() {
        Object command = "";
        for (int i = 0; i < this.commands.length; ++i) {
            if (i > 0) {
                command = (String)command + " ";
            }
            command = (String)command + this.commands[i];
        }
        return command;
    }

    public int getId() {
        return this.jobId;
    }

    public String getLog() {
        return this.logFilename;
    }

    public void addDependency(int jobid) {
        this.dependencies.add(jobid);
    }

    public int getNumberOfDependencies() {
        return this.dependencies.size();
    }

    public int getDependency(int n) {
        if (n < this.dependencies.size()) {
            return this.dependencies.get(n);
        }
        return 0;
    }
}

