/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.schedule;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.MARTiLog;
import uk.ac.earlham.marti.schedule.JobScheduler;
import uk.ac.earlham.marti.schedule.SimpleJobSchedulerJob;

public class SimpleJobScheduler
implements JobScheduler {
    private static final int MAX_QUICK_JOB_ID = 100000;
    private ConcurrentHashMap<Integer, SimpleJobSchedulerJob> allJobs = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, SimpleJobSchedulerJob> failedJobs = new ConcurrentHashMap();
    private LinkedList<SimpleJobSchedulerJob> pendingJobs = new LinkedList();
    private LinkedList<SimpleJobSchedulerJob> runningJobs = new LinkedList();
    private MARTiLog schedulerLog = new MARTiLog();
    private MARTiEngineOptions options;
    private int maxJobs = 4;
    private int jobId = 1;
    private boolean dontRunCommand = false;
    private boolean[] quickCompletedList = new boolean[100000];
    public int[] exitValues = new int[100000];
    long lastLoadReport = System.nanoTime() / 1000000L;

    public SimpleJobScheduler(int m, MARTiEngineOptions o) {
        this.maxJobs = m;
        this.options = o;
        this.schedulerLog.open(o.getLogsDir() + File.separator + "scheduler.txt");
        for (int i = 0; i < 100000; ++i) {
            this.quickCompletedList[i] = false;
            this.exitValues[i] = 0;
        }
    }

    private void printLoad() {
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        double systemCPULoad = osBean.getSystemCpuLoad();
        double processCPULoad = osBean.getProcessCpuLoad();
        long processCPUTime = osBean.getProcessCpuTime() / 1000000000L;
        long freePhysicalMemory = osBean.getFreePhysicalMemorySize() / 0x100000L;
        long totalPhysicalMemory = osBean.getTotalPhysicalMemorySize() / 0x100000L;
        long freeSwapSpace = osBean.getFreeSwapSpaceSize() / 0x100000L;
        long totalSwapSpace = osBean.getTotalSwapSpaceSize() / 0x100000L;
        long committedVirtualMemory = osBean.getCommittedVirtualMemorySize() / 0x100000L;
        String s = String.format("System report sysLoad=%.2f processLoad=%.2f processTime=%d freePhys=%d totalPhys=%d freeSwap=%d totalSwap=%d commitVM=%d", systemCPULoad, processCPULoad, processCPUTime, freePhysicalMemory, totalPhysicalMemory, freeSwapSpace, totalSwapSpace, committedVirtualMemory);
        this.schedulerLog.println(s);
    }

    @Override
    public void setDontRunCommand() {
        this.dontRunCommand = true;
    }

    @Override
    public void setMaxJobs(int m) {
        this.maxJobs = m;
    }

    @Override
    public synchronized int submitJob(String jobPrefix, String uniqueIdentifier, String[] commands, String logFilename, boolean submitJob) {
        boolean dontRunIt = false;
        if (this.dontRunCommand || !submitJob) {
            dontRunIt = true;
        }
        SimpleJobSchedulerJob j = new SimpleJobSchedulerJob(this.options, this.schedulerLog, uniqueIdentifier, this.jobId, commands, logFilename, dontRunIt);
        this.pendingJobs.add(j);
        this.allJobs.put(this.jobId, j);
        this.schedulerLog.println("Submitted job\t" + this.jobId + "\t" + j.getCommand());
        return this.jobId++;
    }

    public synchronized int submitJob(String identifier, String[] commands, String logFilename, String errorFilename, boolean submitJob) {
        boolean dontRunIt = false;
        if (this.dontRunCommand || !submitJob) {
            dontRunIt = true;
        }
        SimpleJobSchedulerJob j = new SimpleJobSchedulerJob(this.options, this.schedulerLog, identifier, this.jobId, commands, logFilename, errorFilename, dontRunIt);
        this.pendingJobs.add(j);
        this.schedulerLog.println("Submitted job\t" + this.jobId + "\t" + j.getCommand());
        return this.jobId++;
    }

    public synchronized int submitJob(SimpleJobSchedulerJob j) {
        j.setJobId(this.jobId);
        this.pendingJobs.add(j);
        this.schedulerLog.println("Submitted job\t" + this.jobId + "\t" + j.getCommand());
        return this.jobId++;
    }

    @Override
    public synchronized void manageQueue(boolean abortWhenPendingJobsCompleted) {
        long timeDiff;
        for (int i = 0; i < this.runningJobs.size(); ++i) {
            SimpleJobSchedulerJob j = this.runningJobs.get(i);
            if (!j.hasFinished()) continue;
            this.schedulerLog.println("Finished job\t" + j.getId() + "\t" + j.getCommand());
            this.schedulerLog.println("Exit value was " + j.getExitValue());
            this.runningJobs.remove(i);
            if (i >= 100000) continue;
            this.quickCompletedList[j.getId()] = true;
            this.exitValues[j.getId()] = j.getExitValue();
        }
        if (!abortWhenPendingJobsCompleted) {
            boolean foundJobToRun = true;
            while (this.runningJobs.size() < this.maxJobs && this.pendingJobs.size() > 0 && foundJobToRun) {
                int index = -1;
                for (int i = 0; i < this.pendingJobs.size(); ++i) {
                    SimpleJobSchedulerJob job = this.pendingJobs.get(i);
                    if (job.getNumberOfDependencies() == 0) {
                        index = i;
                    } else {
                        boolean metDependencies = true;
                        for (int j = 0; j < job.getNumberOfDependencies(); ++j) {
                            if (!this.checkJobCompleted(job.getDependency(j))) {
                                metDependencies = false;
                                this.schedulerLog.println("Job " + job.getId() + " dependency not yet met.");
                                break;
                            }
                            this.schedulerLog.println("Job " + job.getId() + " dependency has been met.");
                        }
                        if (metDependencies) {
                            index = i;
                        }
                    }
                    if (index != -1) break;
                }
                if (index != -1) {
                    SimpleJobSchedulerJob j = this.pendingJobs.remove(index);
                    this.schedulerLog.println("Running job\t" + j.getId() + "\t" + j.getCommand());
                    this.runningJobs.add(j);
                    j.run();
                    continue;
                }
                foundJobToRun = false;
            }
        }
        if ((timeDiff = (System.nanoTime() - this.lastLoadReport) / 1000000L) > 10000L) {
            this.printLoad();
            this.lastLoadReport = System.nanoTime();
        }
    }

    @Override
    public synchronized boolean checkJobCompleted(int i) {
        if (i < 100000) {
            return this.quickCompletedList[i];
        }
        return false;
    }

    @Override
    public synchronized boolean checkJobFailed(int i) {
        boolean failed = false;
        if (this.failedJobs.containsKey(i)) {
            failed = true;
        }
        return failed;
    }

    @Override
    public synchronized int getExitValue(int i) {
        if (i < 100000) {
            return this.exitValues[i];
        }
        return 0;
    }

    @Override
    public synchronized int getRunningJobCount() {
        return this.runningJobs.size();
    }

    @Override
    public synchronized int getPendingJobCount() {
        return this.pendingJobs.size();
    }

    @Override
    public synchronized int getFailedJobCount() {
        return this.failedJobs.size();
    }

    @Override
    public synchronized void markJobAsFailed(int i) {
        SimpleJobSchedulerJob ssj = this.allJobs.get(i);
        this.failedJobs.put(i, ssj);
    }

    @Override
    public synchronized void resubmitJobIfPossible(int i) {
    }

    @Override
    public MARTiLog getSchedulerLog() {
        return this.schedulerLog;
    }
}

