/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.megan;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import uk.ac.earlham.marti.blast.BlastProcess;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.megan.MeganFilePair;

public class MeganFile {
    private MARTiEngineOptions options;
    private ArrayList<MeganFilePair> files = new ArrayList();
    private String barcodeDirectory = null;
    private int lastMeganSubmitted = -1;

    public MeganFile(MARTiEngineOptions o) {
        this.options = o;
    }

    private String getMeganDir() {
        File f;
        String meganDir = this.options.getSampleDirectory() + File.separator + "megan";
        if (this.barcodeDirectory != null) {
            meganDir = meganDir + File.separator + this.barcodeDirectory;
        }
        if (!(f = new File(meganDir)).exists()) {
            f.mkdir();
        }
        return meganDir;
    }

    private String getMeganFilenamePrefix(int n) {
        String filenamePrefix = this.getMeganDir() + File.separator + this.options.getSampleName() + "_" + n;
        return filenamePrefix;
    }

    private void launchMeganJob(String cmdPathname, String logPathname) {
        String[] commands = this.options.useXvfb() ? (this.options.getMeganPropertiesFile() != null ? new String[]{"xvfb-run", this.options.getMeganCmdLine(), "-g", "-c", cmdPathname, "-p", this.options.getMeganPropertiesFile(), "-L", this.options.getMeganLicense()} : new String[]{"xvfb-run", this.options.getMeganCmdLine(), "-g", "-c", cmdPathname, "-L", this.options.getMeganLicense()}) : (this.options.getMeganPropertiesFile() != null ? new String[]{this.options.getMeganCmdLine(), "-g", "-c", cmdPathname, "-p", this.options.getMeganPropertiesFile(), "-L", this.options.getMeganLicense()} : new String[]{this.options.getMeganCmdLine(), "-g", "-c", cmdPathname, "-L", this.options.getMeganLicense()});
        String identifier = "megan_" + cmdPathname;
        int jobid = this.options.getJobScheduler().submitJob("megan", identifier, commands, logPathname, false);
    }

    private void writeMeganLaunchFile(String launchPathname, String slurmLogPathname, String cmdPathname) {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(launchPathname));
            if (this.options.getSchedulerName().equals("slurm")) {
                pw.print("slurmit -p ei-long -c 4 -o " + slurmLogPathname + " -m \"16G\" \"");
            }
            pw.print(this.options.getMeganCmdLine());
            pw.print(" -g -c " + cmdPathname);
            if (this.options.getMeganPropertiesFile() != null) {
                pw.print(" -p " + this.options.getMeganPropertiesFile());
            }
            pw.println(" -L " + this.options.getMeganLicense());
            if (this.options.getSchedulerName().equals("slurm")) {
                pw.print("\"");
            }
            pw.close();
        }
        catch (Exception e) {
            System.out.println("writeMeganLaunchFile exception");
            e.printStackTrace();
        }
    }

    private void writeMeganCommandFile(String cmdPathname, String meganOutPathname, String minSupport, String blastFileString, String fastaFileString) {
        try {
            this.options.getLog().println("Writing MEGAN command file " + cmdPathname);
            PrintWriter pw = new PrintWriter(new FileWriter(cmdPathname));
            pw.println("setprop MaxNumberCores=4;");
            pw.print("import blastFile=" + blastFileString + " fastaFile=" + fastaFileString + " meganFile=" + meganOutPathname);
            pw.println(" maxMatches=100 maxExpected=0.001 " + minSupport + " minComplexity=0 blastFormat=BlastTAB;");
            pw.println("quit;");
            pw.close();
        }
        catch (Exception e) {
            System.out.println("writeMeganCommandFile exception");
            e.printStackTrace();
        }
    }

    private void writeMeganFile(BlastProcess blastProcess) {
        String slurmLogname;
        String slurmPathname;
        String meganPathname;
        String filenamePrefix = this.getMeganFilenamePrefix(this.files.size() - 1);
        Object blastFileString = "";
        Object fastaFileString = "";
        for (int fc = 0; fc < this.files.size(); ++fc) {
            String fileName = "all_" + Integer.toString(fc);
            MeganFilePair mfp = this.files.get(fc);
            String fastaPathname = mfp.getFastaFilename();
            String blastPathname = mfp.getBlastFilename();
            if (blastFileString != "") {
                blastFileString = (String)blastFileString + ",";
                fastaFileString = (String)fastaFileString + ",";
            }
            fastaFileString = (String)fastaFileString + "'" + fastaPathname + "'";
            blastFileString = (String)blastFileString + "'" + blastPathname + "'";
        }
        if (this.options.isDoingMeganMinSupport()) {
            String cmdPathname = filenamePrefix + "_ms1.cmds";
            meganPathname = filenamePrefix + "_ms1.rma";
            slurmPathname = filenamePrefix + "_ms1.sh";
            slurmLogname = filenamePrefix + "_ms1_slurm.log";
            this.writeMeganCommandFile(cmdPathname, meganPathname, "minSupport=1", (String)blastFileString, (String)fastaFileString);
            this.writeMeganLaunchFile(slurmPathname, slurmLogname, cmdPathname);
        }
        if (this.options.isDoingMeganMinSupportPercent()) {
            String cmdPathname = filenamePrefix + "_ms0.1pc.cmds";
            meganPathname = filenamePrefix + "_ms0.1pc.rma";
            slurmPathname = filenamePrefix + "_ms0.1pc.sh";
            slurmLogname = filenamePrefix + "_ms0.1pc_slurm.log";
            this.writeMeganLaunchFile(slurmPathname, slurmLogname, cmdPathname);
            this.writeMeganCommandFile(cmdPathname, meganPathname, "minSupportPercent=0.1", (String)blastFileString, (String)fastaFileString);
        }
    }

    public void addBlastResult(String fastaPath, String blastPath, int jobid) {
        this.files.add(new MeganFilePair(fastaPath, blastPath, jobid));
        if (this.barcodeDirectory == null) {
            String bcString;
            this.barcodeDirectory = fastaPath.contains("barcode") ? (bcString = fastaPath.substring(fastaPath.indexOf("barcode"), fastaPath.indexOf("barcode") + 9)) : "";
        }
        ArrayList<BlastProcess> bp = this.options.getBlastProcesses();
        for (int i = 0; i < bp.size(); ++i) {
            BlastProcess blastProcess = bp.get(i);
            this.writeMeganFile(blastProcess);
        }
    }

    private void runMegan(int f) {
        String logname;
        String cmdPathname;
        String filenamePrefix = this.getMeganFilenamePrefix(f);
        if (this.options.isDoingMeganMinSupport()) {
            cmdPathname = filenamePrefix + "_ms1.cmds";
            logname = filenamePrefix + "_ms1.log";
            this.launchMeganJob(cmdPathname, logname);
        }
        if (this.options.isDoingMeganMinSupportPercent()) {
            cmdPathname = filenamePrefix + "_ms0.1pc.cmds";
            logname = filenamePrefix + "_ms0.1pc.log";
            this.launchMeganJob(cmdPathname, logname);
        }
        this.lastMeganSubmitted = f;
    }

    public void checkForMeganJobInitiation(BlastProcess blastProcess) {
        for (int f = this.lastMeganSubmitted + 1; f < this.files.size(); ++f) {
            MeganFilePair mfp = this.files.get(f);
            if (!this.options.getJobScheduler().checkJobCompleted(mfp.getJobId())) break;
            this.options.getLog().println("BLAST job complete for file " + f + " " + this.barcodeDirectory);
            boolean runMeganNow = false;
            if (blastProcess.getRunMeganEvery() == 1 && f == 0) {
                runMeganNow = true;
            } else if ((f + 1) % blastProcess.getRunMeganEvery() == 0) {
                runMeganNow = true;
            }
            if (!runMeganNow) continue;
            this.options.getLog().println("Running MEGAN job upto file " + f + " " + this.barcodeDirectory);
            this.runMegan(f);
        }
    }

    public int getNumberOfFiles() {
        return this.files.size();
    }
}

