/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.kraken2;

import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.earlham.marti.core.FASTAQPair;
import uk.ac.earlham.marti.core.FASTAQPairPendingList;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.ProcessLogger;

public class Kraken2ProcessRunnable
implements Runnable {
    private MARTiEngineOptions options;
    private FASTAQPairPendingList pendingFileList = null;
    private boolean keepRunning = true;
    private int numberOfReadsProcessed = 0;

    public Kraken2ProcessRunnable(MARTiEngineOptions o, FASTAQPairPendingList pfl) {
        this.options = o;
        this.pendingFileList = pfl;
    }

    private void runCommandLocal(String command, String outPath) {
        ProcessLogger pl = new ProcessLogger();
        if (outPath != null) {
            pl.setWriteFormat(false, true, false);
            pl.runAndLogCommand(command, outPath, false);
        } else {
            pl.runCommand(command);
        }
    }

    public void exitThread() {
        this.keepRunning = false;
    }

    private void runKraken2(String fastqPathname) {
        this.options.getKraken2Handler().addReadChunk(fastqPathname);
        if (this.options.getStopProcessingAfter() > 0 && this.numberOfReadsProcessed > this.options.getStopProcessingAfter()) {
            this.options.getLog().println("Note: Number of FASTQ reads processed (" + this.numberOfReadsProcessed + ") exceeeds limit (" + this.options.getStopProcessingAfter() + "). Sending STOP command.");
            this.options.stopProcessing();
        }
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            FASTAQPair fa = null;
            while (fa == null && this.keepRunning) {
                fa = this.pendingFileList.getKraken2PendingPair();
                if (fa != null) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Kraken2ProcessRunnable.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (fa == null) continue;
            String pendingFile = fa.getFastq();
            this.runKraken2(pendingFile);
        }
        this.options.getLog().println("Kraken2ProcessRunnable thread ended");
    }
}

