/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.kraken2;

import java.io.BufferedReader;
import java.io.File;
import uk.ac.earlham.marti.core.MARTiAlert;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.schedule.SlurmScheduler;

public class Kraken2Process {
    private MARTiEngineOptions options;
    private String kraken2Name = null;
    private String kraken2Database = null;
    private int numThreads = 1;
    private boolean classifyThis = false;
    private String kraken2Memory = null;
    private String jobQueue = null;
    private int minHitGroups = 1;
    private int primaryAssignments = 1;
    private String processOptions = "";

    public Kraken2Process(MARTiEngineOptions o) {
        this.options = o;
    }

    public String readConfigFile(BufferedReader br) {
        String line = null;
        this.jobQueue = this.options.getQueue();
        boolean keepReading = true;
        try {
            do {
                if ((line = br.readLine()) == null || (line = line.trim()).length() <= 1 || line.startsWith("#")) continue;
                String[] tokens = line.split(":");
                if (tokens[0].compareToIgnoreCase("Name") == 0) {
                    this.kraken2Name = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Database") == 0) {
                    this.kraken2Database = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Memory") == 0) {
                    this.kraken2Memory = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Queue") == 0) {
                    this.jobQueue = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Kraken2Threads") == 0) {
                    this.numThreads = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("UseToClassify") == 0) {
                    this.classifyThis = true;
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("options") == 0) {
                    this.processOptions = tokens[1];
                    continue;
                }
                keepReading = false;
            } while (line != null && keepReading);
        }
        catch (Exception e) {
            System.out.println("readConfigFile Exception:");
            e.printStackTrace();
            System.exit(1);
        }
        if (this.kraken2Name == null) {
            System.out.println("Error: missing Kraken2 name.");
            this.options.addAlert(new MARTiAlert(3, "Error: missing name in Kraken2 process. Analysis stopped."));
            this.options.writeAlertsFile();
            System.exit(1);
        }
        if (this.kraken2Database == null) {
            System.out.println("Error: missing Kraken2 database.");
            this.options.addAlert(new MARTiAlert(3, "Error: missing database in Kraken2 process. Analysis stopped."));
            this.options.writeAlertsFile();
            System.exit(1);
        }
        if (this.options.getJobScheduler() instanceof SlurmScheduler) {
            if (this.kraken2Memory == null) {
                System.out.println("Error: missing memory in Kraken2 process config.");
                this.options.addAlert(new MARTiAlert(3, "Error: missing memory in Kraken2 process. Analysis stopped."));
                this.options.writeAlertsFile();
                System.exit(1);
            }
            if (this.jobQueue == null) {
                System.out.println("Error: missing job queue in Kraken2 process config.");
                this.options.addAlert(new MARTiAlert(3, "Error: missing queue in Kraken2 process. Analysis stopped."));
                this.options.writeAlertsFile();
                System.exit(1);
            }
        }
        return line;
    }

    public String getName() {
        return this.kraken2Name;
    }

    public String getDatabase() {
        return this.kraken2Database;
    }

    public String getJobQueue() {
        return this.jobQueue;
    }

    public String getMemory() {
        return this.kraken2Memory;
    }

    public boolean useForClassifying() {
        return this.classifyThis;
    }

    public String getProcessDir() {
        return this.options.getSampleDirectory() + File.separator + "kraken2_" + this.kraken2Name + File.separator;
    }

    public int getMinHitGroups() {
        return this.minHitGroups;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public int getNumPrimaryAssignments() {
        return this.primaryAssignments;
    }

    public String getProcessOptions() {
        return this.processOptions;
    }
}

