/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.kraken2;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.kraken2.Kraken2Process;
import uk.ac.earlham.marti.schedule.JobScheduler;
import uk.ac.earlham.marti.schedule.SlurmScheduler;

public class Kraken2Handler {
    private MARTiEngineOptions options = null;
    private int kraken2JobCount = 0;

    public Kraken2Handler(MARTiEngineOptions o) {
        this.options = o;
    }

    private synchronized boolean checkKraken2FilesExist(String inputPathname) {
        boolean gotAll = true;
        ArrayList<Kraken2Process> kraken2Processes = this.options.getKraken2Processes();
        for (int i = 0; i < kraken2Processes.size(); ++i) {
            File fgz;
            Kraken2Process k2p = kraken2Processes.get(i);
            String kraken2File = this.getKraken2FilePathPrefixFromFastqFilePath(inputPathname, k2p) + "_classification.txt";
            File f = new File(kraken2File);
            if (f.exists() || (fgz = new File(kraken2File + ".gz")).exists()) continue;
            this.options.getLog().println("dontrunblast - can't find kraken2 files " + kraken2File + " or " + kraken2File + ".gz");
            gotAll = false;
        }
        return gotAll;
    }

    private synchronized void runKraken2(String inputPathname) {
        int barcode = this.options.getBarcodeFromPath(inputPathname);
        ArrayList<Kraken2Process> kraken2Processes = this.options.getKraken2Processes();
        String classifyFilename = null;
        int classifyId = 0;
        if (!this.options.runBlastCommand() && !this.checkKraken2FilesExist(inputPathname)) {
            this.options.getLog().println("dontrunblast - ignoring " + inputPathname + " due to missing Kraken2 files");
            this.options.getProgressReport().decrementChunkCount();
            return;
        }
        for (int i = 0; i < kraken2Processes.size(); ++i) {
            Kraken2Process k2p = kraken2Processes.get(i);
            String database = k2p.getDatabase();
            String numThreads = Integer.toString(k2p.getNumThreads());
            String classificationFilePath = this.getKraken2FilePathPrefixFromFastqFilePath(inputPathname, k2p) + "_classification.txt";
            String commandFilePath = this.getKraken2FilePathPrefixFromFastqFilePath(inputPathname, k2p) + ".sh";
            String logFilePath = this.getKraken2LogFilePathFromFastqFilePath(inputPathname, k2p);
            this.options.getLog().println(" Kraken2 input: " + inputPathname);
            this.options.getLog().println(" Kraken2 classification output: " + classificationFilePath);
            this.options.getLog().println(" Kraken2 command: " + commandFilePath);
            this.options.getLog().println(" Kraken2 log: " + logFilePath);
            try {
                this.options.getLog().println("Writing Kraken2 command file " + commandFilePath);
                PrintWriter pw = new PrintWriter(new FileWriter(commandFilePath));
                Object command = "";
                JobScheduler jobScheduler = this.options.getJobScheduler();
                String identifier = "kraken2_" + inputPathname;
                String processOptions = k2p.getProcessOptions();
                command = "kraken2";
                if (processOptions.length() > 0) {
                    command = (String)command + " " + processOptions;
                }
                command = (String)command + " --db " + database + " --output " + classificationFilePath + " --threads " + numThreads + " " + inputPathname;
                pw.write((String)command);
                pw.close();
                int jobid = 0;
                if (jobScheduler == null) {
                    System.out.println("Shouldn't get to a null job scheduler!");
                } else {
                    ArrayList<Object> commands = new ArrayList<Object>();
                    commands.add("kraken2");
                    if (processOptions.length() > 0) {
                        commands.addAll(new ArrayList<String>(Arrays.asList(processOptions.split(" "))));
                    }
                    commands.add("--db");
                    commands.add(database);
                    commands.add("--output");
                    commands.add(classificationFilePath);
                    commands.add("--threads");
                    commands.add(numThreads);
                    commands.add(inputPathname);
                    boolean runIt = this.options.runBlastCommand();
                    String[] commandString = commands.toArray(new String[commands.size()]);
                    jobid = jobScheduler.submitJob("kraken2", identifier, commandString, logFilePath, runIt);
                    if (jobScheduler instanceof SlurmScheduler) {
                        ((SlurmScheduler)jobScheduler).setCPUs(jobid, k2p.getNumThreads());
                        ((SlurmScheduler)jobScheduler).setJobMemory(jobid, k2p.getMemory());
                        ((SlurmScheduler)jobScheduler).setQueue(jobid, k2p.getJobQueue());
                    }
                    if (k2p.useForClassifying()) {
                        classifyFilename = classificationFilePath;
                        classifyId = jobid;
                    }
                }
                if (this.options.isClassifyingReads()) {
                    this.options.getKraken2Classifier().addFile(k2p.getName(), jobid, inputPathname, classificationFilePath);
                }
                this.options.getProgressReport().incrementChunksKraken2dCount();
                ++this.kraken2JobCount;
                continue;
            }
            catch (IOException e) {
                System.out.println("runKraken2 exception");
                e.printStackTrace();
            }
        }
    }

    public synchronized void addReadChunk(String readFilename) {
        this.runKraken2(readFilename);
    }

    private String getBarcodeSubdirFromPath(String pathname, String parent) {
        File fullDirFile;
        Object subDir = "";
        Object fullDir = "";
        if (pathname.contains("barcode")) {
            String bcString = pathname.substring(pathname.indexOf("barcode"), pathname.indexOf("barcode") + 9);
            subDir = bcString + File.separator;
        }
        if (!(fullDirFile = new File((String)(fullDir = parent + (String)subDir))).exists()) {
            this.options.getLog().println("Creating dir " + (String)fullDir);
            fullDirFile.mkdir();
        }
        return subDir;
    }

    private String getKraken2FilePathPrefixFromFastqFilePath(String fastqPath, Kraken2Process k2p) {
        File fastqFile = new File(fastqPath);
        String leafName = fastqFile.getName();
        String filePrefix = leafName.substring(0, leafName.lastIndexOf(46));
        String processDir = k2p.getProcessDir();
        String path = processDir + this.getBarcodeSubdirFromPath(fastqPath, processDir) + filePrefix;
        return path;
    }

    private String getKraken2LogFilePathFromFastqFilePath(String fastqPath, Kraken2Process k2p) {
        File fastqFile = new File(fastqPath);
        String leafName = fastqFile.getName();
        String filePrefix = leafName.substring(0, leafName.lastIndexOf(46));
        String logsDir = this.options.getLogsDir() + File.separator + "kraken2_" + k2p.getName() + File.separator;
        String logPath = logsDir + this.getBarcodeSubdirFromPath(fastqPath, logsDir) + filePrefix + ".log";
        return logPath;
    }
}

