/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.kraken2;

import java.io.File;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import uk.ac.earlham.marti.core.MARTiAlert;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.SampleMetaData;
import uk.ac.earlham.marti.kraken2.Kraken2ClassifierItem;
import uk.ac.earlham.marti.schedule.JobScheduler;

public class Kraken2Classifier {
    private MARTiEngineOptions options;
    private Hashtable<Integer, Kraken2ClassifierItem> pendingFiles = new Hashtable();
    private Hashtable<String, Integer> barcodes = new Hashtable();
    private ConcurrentLinkedQueue<String> fileCompressionQueue = null;
    private int filesProcessed = 0;
    private int fileCount = 0;

    public Kraken2Classifier(MARTiEngineOptions o) {
        this.options = o;
    }

    public synchronized void addFile(String kraken2ProcessName, int id, String queryFilename, String classificationFilename) {
        File fgz;
        File f;
        boolean ignoreThis = false;
        if (!(this.options.runBlastCommand() || (f = new File(classificationFilename)).exists() || (fgz = new File(classificationFilename + ".gz")).exists())) {
            this.options.getLog().println("dontrunblast - files " + classificationFilename + " and " + classificationFilename + ".gz don't exist, so ignoring");
            ignoreThis = true;
        }
        if (!ignoreThis) {
            String bcString;
            this.pendingFiles.put(id, new Kraken2ClassifierItem(kraken2ProcessName, id, queryFilename, classificationFilename));
            ++this.fileCount;
            if (classificationFilename.contains("barcode") && !this.barcodes.containsKey(bcString = classificationFilename.substring(classificationFilename.indexOf("barcode"), classificationFilename.indexOf("barcode") + 9))) {
                this.barcodes.put(bcString, 1);
            }
        }
    }

    public void setFileCompressionQueue(ConcurrentLinkedQueue<String> queue) {
        if (this.fileCompressionQueue == null) {
            this.fileCompressionQueue = queue;
        } else {
            System.out.println("[Kraken2Classifier] Warning: Setting file compression queue but this has already been set. Something has gone wrong.");
        }
    }

    private boolean checkKraken2Completed(Kraken2ClassifierItem f, int exitValue) {
        return exitValue == 0;
    }

    public synchronized void checkForFilesToClassify() {
        JobScheduler js = this.options.getJobScheduler();
        Set<Integer> asSet = this.pendingFiles.keySet();
        Integer[] ids = asSet.toArray(new Integer[asSet.size()]);
        this.options.getLog().println(3, "In checkForFilesToClassify Kraken2 - size " + ids.length);
        for (int i = 0; i < ids.length; ++i) {
            int thisId = ids[i];
            Kraken2ClassifierItem f = this.pendingFiles.get(thisId);
            if (!js.checkJobCompleted(thisId)) continue;
            if (this.checkKraken2Completed(f, js.getExitValue(thisId))) {
                this.options.getLog().println("Running parse on " + f.getClassificationFile());
                long startTime = System.nanoTime();
                int barcode = this.options.getBarcodeFromPath(f.getClassificationFile());
                SampleMetaData md = this.options.getSampleMetaData(barcode);
                this.options.getLog().println("Got sample metadata");
                this.options.getLog().println("Registering chunks");
                md.registerChunkAnalysed(f.getQueryFile().replaceAll("fastq", "fasta"));
                int fastaChunkNumber = this.getChunkNumber(f.getClassificationFile());
                int chunkNumberByOrderCompleted = this.options.getResults().addChunk(barcode, f);
                this.options.getResults().writeTree(barcode, 0.0);
                this.options.getResults().storeAccumulationData(barcode, fastaChunkNumber, chunkNumberByOrderCompleted, md.getReadsAnalysed(), md.getLastChunkAnalysedTime(), 0.0);
                this.options.getResults().writeAccumulationJson(barcode, 0.0);
                this.options.getResults().writeTree(barcode, 0.1);
                this.options.getResults().storeAccumulationData(barcode, fastaChunkNumber, chunkNumberByOrderCompleted, md.getReadsAnalysed(), md.getLastChunkAnalysedTime(), 0.1);
                this.options.getResults().writeAccumulationJson(barcode, 0.1);
                this.options.getResults().writeTree(barcode, 1.0);
                this.options.getResults().storeAccumulationData(barcode, fastaChunkNumber, chunkNumberByOrderCompleted, md.getReadsAnalysed(), md.getLastChunkAnalysedTime(), 1.0);
                this.options.getResults().writeAccumulationJson(barcode, 1.0);
                this.options.getResults().writeTree(barcode, 2.0);
                this.options.getResults().storeAccumulationData(barcode, fastaChunkNumber, chunkNumberByOrderCompleted, md.getReadsAnalysed(), md.getLastChunkAnalysedTime(), 2.0);
                this.options.getResults().writeAccumulationJson(barcode, 2.0);
                ++this.filesProcessed;
                this.pendingFiles.remove(thisId);
                this.options.getProgressReport().incrementKraken2ChunksParsedCount();
                md.writeSampleJSON(false);
                continue;
            }
            this.options.getLog().printlnLogAndScreen("Kraken2 failed on " + f.getQueryFile());
            this.options.addAlertOnlyOnce(new MARTiAlert(3, "Kraken2 failed on " + f.getQueryFile()));
            this.options.getLog().printlnLogAndScreen("Exiting prematurely after Kraken2 failure.");
            ++this.filesProcessed;
            this.pendingFiles.remove(thisId);
            this.options.getProgressReport().incrementKraken2ChunksParsedCount();
            this.options.getProgressReport().setAbortWhenCurrentJobsComplete();
        }
    }

    private int getChunkNumber(String filename) {
        int chunkNumber = -1;
        File f = new File(filename);
        String leafName = f.getName();
        String[] fields = leafName.split("_");
        chunkNumber = Integer.parseInt(fields[fields.length - 2]);
        return chunkNumber;
    }
}

