/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import uk.ac.earlham.marti.core.FASTAQPairPendingList;
import uk.ac.earlham.marti.core.MARTiAlert;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.ReadStatistics;
import uk.ac.earlham.marti.core.SampleMetaData;
import uk.ac.earlham.marti.watcher.FileWatcher;

public class ReadFilterSample {
    private static final int TYPE_FASTQ = 1;
    private static final int TYPE_FASTA = 2;
    private MARTiEngineOptions options;
    private FileWatcher fileWatcher;
    private boolean isNewStyleDir;
    private int numberOfReadsProcessed = 0;
    private boolean writeFastq = true;
    private boolean writeFasta = true;
    PrintWriter pwFastq = null;
    PrintWriter pwFasta = null;
    private int chunkNumber = -1;
    private int readCountInChunk = 0;
    private long bpInChunk = 0L;
    private String currentFastqChunkFilename = null;
    private String currentFastaChunkFilename = null;
    private ArrayList<Integer> allReadLengths = new ArrayList();
    private ArrayList<Integer> writtenReadLengths = new ArrayList();
    private ArrayList<Integer> chunkReadLengths = new ArrayList();
    private int readsFilteredFromChunk = 0;
    private int readsFilteredTotal = 0;
    private FASTAQPairPendingList pendingPairList = null;
    private boolean stopProcessingChunks = false;
    private int barcode = 0;
    private SampleMetaData metaData = null;
    private ReadStatistics readStatistics = null;

    public ReadFilterSample(MARTiEngineOptions o, FileWatcher f, FASTAQPairPendingList pfl, int bc) {
        this.options = o;
        this.fileWatcher = f;
        this.pendingPairList = pfl;
        this.barcode = bc;
        this.metaData = this.options.getSampleMetaData(this.barcode);
        if (this.options.isBlastingRead()) {
            this.writeFasta = true;
        }
        this.readStatistics = this.options.getReadStatistics();
    }

    private String generateFastaFastqChunkPath(String fastqPathname, int type) {
        String aqDir;
        File f = new File(fastqPathname);
        String fastqLeafname = f.getName();
        Object chunkPathname = "";
        String suffix = "";
        int lastUnderscore = fastqLeafname.lastIndexOf(95);
        Object newLeafname = "";
        if (type == 2) {
            aqDir = this.options.getFastaDir();
            suffix = ".fasta";
        } else {
            aqDir = this.options.getFastqDir();
            suffix = ".fastq";
        }
        if (lastUnderscore > 0) {
            newLeafname = fastqLeafname.substring(0, lastUnderscore) + "_filtered_" + this.chunkNumber + suffix;
        } else {
            int lastDot = fastqLeafname.lastIndexOf(46);
            if (lastDot > 0) {
                newLeafname = fastqLeafname.substring(0, lastDot) + "_filtered_" + this.chunkNumber + suffix;
                this.options.getLog().println("Warning: FASTA/Q filename not as expected: " + fastqLeafname);
                this.options.getLog().println("Results unpredictable");
                System.out.println("Warning: FASTA/Q filename not as expected: " + fastqLeafname);
            } else {
                newLeafname = fastqLeafname + "_filtered_" + this.chunkNumber + suffix;
                this.options.getLog().println("Error: FASTA/Q filename not as expected: " + fastqLeafname);
                System.out.println("Error: FASTA/Q filename not as expected: " + fastqLeafname);
                this.options.getLog().println("Results unpredictable");
            }
        }
        String chunksDir = aqDir + "_chunks";
        if (this.options.isBarcoded()) {
            int barcode = this.options.getBarcodeFromPath(fastqPathname);
            String bcDir = barcode < 10 ? chunksDir + File.separator + "barcode0" + barcode : chunksDir + File.separator + "barcode" + barcode;
            File df = new File(bcDir);
            if (!df.exists()) {
                df.mkdir();
            }
            chunkPathname = bcDir + File.separator + (String)newLeafname;
        } else {
            chunkPathname = chunksDir + File.separator + (String)newLeafname;
        }
        return chunkPathname;
    }

    private void checkForNewChunk(String fastqFilename) {
        if (this.readCountInChunk == 0) {
            ++this.chunkNumber;
            this.chunkReadLengths = new ArrayList();
            this.readsFilteredFromChunk = 0;
            if (this.writeFastq) {
                this.currentFastqChunkFilename = this.generateFastaFastqChunkPath(fastqFilename, 1);
                this.options.getLog().println("Creating FASTQ chunk " + this.currentFastqChunkFilename + ".tmp");
                try {
                    this.pwFastq = new PrintWriter(new FileWriter(this.currentFastqChunkFilename + ".tmp"));
                }
                catch (Exception e) {
                    System.out.println("Error opening " + this.currentFastqChunkFilename);
                    e.printStackTrace();
                }
            }
            if (this.writeFasta) {
                this.currentFastaChunkFilename = this.generateFastaFastqChunkPath(fastqFilename, 2);
                this.options.getLog().println("Creating FASTA chunk " + this.currentFastaChunkFilename + ".tmp");
                try {
                    this.pwFasta = new PrintWriter(new FileWriter(this.currentFastaChunkFilename + ".tmp"));
                }
                catch (Exception e) {
                    System.out.println("Error opening " + this.currentFastaChunkFilename);
                    e.printStackTrace();
                }
            }
            this.options.getProgressReport().incrementChunkCount();
        }
    }

    private void writeFastq(String header, String seq, String plus, String qual) {
        if (this.pwFastq != null) {
            this.pwFastq.println(header);
            this.pwFastq.println(seq);
            this.pwFastq.println(plus);
            this.pwFastq.println(qual);
        }
    }

    private void writeFasta(String header, String seq) {
        if (this.pwFasta != null) {
            this.pwFasta.println(">" + header.substring(1));
            this.pwFasta.println(seq);
        }
    }

    private synchronized void endChunks() {
        try {
            Path dest;
            Path source;
            if (this.pwFastq != null) {
                this.pwFastq.close();
                this.options.getLog().println("Removing .tmp from " + this.currentFastqChunkFilename + ".tmp");
                source = Paths.get(this.currentFastqChunkFilename + ".tmp", new String[0]);
                dest = Paths.get(this.currentFastqChunkFilename, new String[0]);
                try {
                    Files.move(source, dest, StandardCopyOption.REPLACE_EXISTING);
                    this.options.getProgressReport().recordCompleted("chunk_" + this.currentFastqChunkFilename);
                }
                catch (Exception e) {
                    this.options.getLog().println("Move failed");
                    this.options.getLog().println("Source was " + String.valueOf(source));
                    this.options.getLog().println("Destination was " + String.valueOf(dest));
                }
            } else {
                this.options.getLog().println("No FASTQ to move");
            }
            if (this.pwFasta != null) {
                this.pwFasta.close();
                this.options.getLog().println("Removing .tmp from " + this.currentFastaChunkFilename + ".tmp");
                source = Paths.get(this.currentFastaChunkFilename + ".tmp", new String[0]);
                dest = Paths.get(this.currentFastaChunkFilename, new String[0]);
                try {
                    Files.move(source, dest, StandardCopyOption.REPLACE_EXISTING);
                    this.options.getProgressReport().recordCompleted("chunk_" + this.currentFastaChunkFilename);
                }
                catch (Exception e) {
                    this.options.getLog().println("Move failed");
                    this.options.getLog().println("Source was " + String.valueOf(source));
                    this.options.getLog().println("Destination was " + String.valueOf(dest));
                }
            } else {
                this.options.getLog().println("No FASTA to move");
            }
            this.options.getLog().println("Moves complete.");
            this.metaData.registerFilteredFastaChunk(this.currentFastaChunkFilename, this.readCountInChunk, this.bpInChunk);
            this.metaData.writeSampleJSON(false);
            this.options.getLog().println("Now to add to pending pair list");
            this.pendingPairList.addPendingPair(this.currentFastaChunkFilename, this.currentFastqChunkFilename);
            double meanLength = this.getMeanReadLength(this.chunkReadLengths);
            this.options.getLog().println("Chunk mean read length = " + meanLength + " for " + this.currentFastaChunkFilename);
            this.options.getLog().println("Reads filtered from chunk = " + this.readsFilteredFromChunk);
            this.readCountInChunk = 0;
            this.bpInChunk = 0L;
            if (this.options.getStopProcessingAfter() > 0 && this.writtenReadLengths.size() >= this.options.getStopProcessingAfter()) {
                this.options.getLog().println("Got enough reads, so stopping ");
                this.stopProcessingChunks = true;
                this.options.setHasReachedReadOrTimeLimit();
            }
            if (!this.stopProcessingChunks && this.options.timeUp()) {
                this.options.getLog().println("Time up, so stopping ");
                this.stopProcessingChunks = true;
                this.options.setHasReachedReadOrTimeLimit();
            }
        }
        catch (Exception e) {
            System.out.println("Error in checkForEndChunk");
            e.printStackTrace();
        }
    }

    private double calculateMeanQuality(String qual) {
        long totalQ = 0L;
        double totalProb = 0.0;
        for (int i = 0; i < qual.length(); ++i) {
            int qScore = qual.charAt(i) - 33;
            double prob = Math.pow(10.0, -((double)qScore / 10.0));
            totalQ += (long)qScore;
            totalProb += prob;
        }
        double meanProb = totalProb / (double)qual.length();
        double meanQFromP = -10.0 * Math.log10(meanProb);
        double meanQ = (double)totalQ / (double)qual.length();
        return meanQFromP;
    }

    public void processFile(String fastqPathname) {
        boolean processThis = true;
        if (this.metaData.getSequencingTimeString() == "") {
            this.metaData.setDateFromSequenceFile(fastqPathname);
        }
        if (this.stopProcessingChunks) {
            this.options.getLog().println("Got enough reads, so ignoring file " + fastqPathname);
            this.options.getLog().println("PendingPairList: processed=" + this.pendingPairList.getFilesProcessed() + " pending=" + this.pendingPairList.getPendingFileCount());
        }
        if (!this.stopProcessingChunks) {
            this.options.getLog().printlnLogAndScreen("Processing file (RFS) " + fastqPathname);
            try {
                String header;
                BufferedReader br = null;
                FileInputStream fileStream = null;
                GZIPInputStream gzipStream = null;
                Reader decoder = null;
                int bufferSize = 0x400000;
                if (fastqPathname.toLowerCase().endsWith(".fastq") || fastqPathname.toLowerCase().endsWith(".fq")) {
                    br = new BufferedReader(new FileReader(fastqPathname), bufferSize);
                    if (br == null) {
                        this.options.getLog().printlnLogAndScreen("Couldn't open file " + fastqPathname);
                        System.exit(1);
                    }
                } else if (fastqPathname.toLowerCase().endsWith(".fastq.gz") || fastqPathname.toLowerCase().endsWith(".fq.gz")) {
                    fileStream = new FileInputStream(fastqPathname);
                    if (fileStream != null) {
                        gzipStream = new GZIPInputStream(fileStream);
                        if (gzipStream != null) {
                            decoder = new InputStreamReader((InputStream)gzipStream, "US-ASCII");
                            if (decoder != null) {
                                br = new BufferedReader(decoder, bufferSize);
                                if (br == null) {
                                    this.options.getLog().printlnLogAndScreen("Couldn't open file " + fastqPathname);
                                    System.exit(1);
                                }
                            } else {
                                this.options.getLog().printlnLogAndScreen("Couldn't open decoder for " + fastqPathname);
                                System.exit(1);
                            }
                        } else {
                            this.options.getLog().printlnLogAndScreen("Couldn't open GZIP stream for " + fastqPathname);
                            System.exit(1);
                        }
                    } else {
                        this.options.getLog().printlnLogAndScreen("Couldn't open filestream for " + fastqPathname);
                        System.exit(1);
                    }
                } else {
                    this.options.getLog().printlnLogAndScreen("Unknown suffix for " + fastqPathname);
                    System.exit(1);
                }
                if (br == null) {
                    this.options.getLog().printlnLogAndScreen("Ooops shouldn't have got to here without a .fastq or a .fq or a .fastq.gz or a .fq.gz");
                    System.exit(1);
                }
                while ((header = br.readLine()) != null && !this.stopProcessingChunks) {
                    if (!header.startsWith("@")) {
                        this.options.getLog().printlnLogAndScreen("ERROR: Badly formatted FASTQ file (didn't find header when expected) in " + fastqPathname);
                        this.options.getLog().printlnLogAndScreen("H: " + header);
                        this.options.getLog().printlnLogAndScreen("Attempting to continue, but recommend checking file");
                        this.options.addAlertOnlyOnce(new MARTiAlert(3, "Error: Badly formatted FASTQ entry in " + fastqPathname));
                        continue;
                    }
                    String seq = br.readLine();
                    br.mark(bufferSize);
                    String plus = br.readLine();
                    if (!plus.equals("+")) {
                        this.options.getLog().printlnLogAndScreen("ERROR: Badly formatted FASTQ entry (missing + before quality scores) in " + fastqPathname);
                        this.options.getLog().printlnLogAndScreen("H: " + header);
                        this.options.getLog().printlnLogAndScreen("S: " + seq);
                        this.options.getLog().printlnLogAndScreen("P: " + plus);
                        this.options.getLog().printlnLogAndScreen("Attempting to continue without this read, but recommend checking file");
                        this.options.addAlertOnlyOnce(new MARTiAlert(3, "Error: Badly formatted FASTQ entry in " + fastqPathname));
                        br.reset();
                        continue;
                    }
                    String qual = br.readLine();
                    boolean readPassedFilter = true;
                    String readID = header.split("\\s+")[0].substring(1);
                    double meanQ = this.calculateMeanQuality(qual);
                    this.allReadLengths.add(seq.length());
                    if (meanQ >= (double)this.options.getReadFilterMinQ() && seq.length() >= this.options.getReadFilterMinLength()) {
                        this.checkForNewChunk(fastqPathname);
                        if (this.writeFastq) {
                            this.writeFastq(header, seq, plus, qual);
                        }
                        if (this.writeFasta) {
                            this.writeFasta(header, seq);
                        }
                        ++this.readCountInChunk;
                        this.bpInChunk += (long)seq.length();
                        this.writtenReadLengths.add(seq.length());
                        this.chunkReadLengths.add(seq.length());
                        this.readStatistics.addReadLength(this.barcode, readID, seq.length(), true);
                        if (this.readCountInChunk == this.options.getReadsPerBlast()) {
                            this.endChunks();
                        }
                    } else {
                        ++this.readsFilteredFromChunk;
                        ++this.readsFilteredTotal;
                        readPassedFilter = false;
                        this.readStatistics.addReadLength(this.barcode, readID, seq.length(), false);
                    }
                    this.metaData.registerNewInputRead(seq.length(), meanQ, readPassedFilter);
                    ++this.numberOfReadsProcessed;
                }
                br.close();
                if (fastqPathname.toLowerCase().endsWith(".gz")) {
                    decoder.close();
                    ((InputStream)gzipStream).close();
                    ((InputStream)fileStream).close();
                }
                this.options.getProgressReport().markRawFileProcessed(fastqPathname);
            }
            catch (IOException e) {
                System.out.println("runConvertFastQ exception");
                e.printStackTrace();
            }
            this.options.getProgressReport().recordCompleted("filter_" + fastqPathname);
        }
    }

    private double getMeanReadLength(ArrayList<Integer> lengths) {
        double mean = 0.0;
        long total = 0L;
        for (int i = 0; i < lengths.size(); ++i) {
            total += (long)lengths.get(i).intValue();
        }
        mean = (double)total / (double)lengths.size();
        return mean;
    }

    public int getPendingCount() {
        return this.pendingPairList.getFilesToProcessCount();
    }

    public void finalise() {
        if (this.readCountInChunk > 0) {
            this.endChunks();
        }
    }

    public void outputStats() {
        this.options.getLog().println("Barcode " + this.barcode + " Total reads filtered " + this.readsFilteredTotal);
        double meanLength = this.getMeanReadLength(this.allReadLengths);
        this.options.getLog().println("Barcode " + this.barcode + " Mean read length (all) = " + meanLength);
        meanLength = this.getMeanReadLength(this.writtenReadLengths);
        this.options.getLog().println("Barcode " + this.barcode + " Mean read length (written) = " + meanLength);
    }
}

