/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.filter;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.earlham.marti.core.FASTAQPairPendingList;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.filter.ReadFilterSample;
import uk.ac.earlham.marti.watcher.FileWatcher;
import uk.ac.earlham.marti.watcher.FileWatcherItem;

public class ReadFilterRunnable
implements Runnable {
    private static final int MAX_BARCODES = 100;
    private static final int TYPE_FASTQ = 1;
    private static final int TYPE_FASTA = 2;
    private MARTiEngineOptions options;
    private FileWatcher fileWatcher;
    private boolean isNewStyleDir;
    private int numberOfReadsProcessed = 0;
    private boolean writeFastq = true;
    private boolean writeFasta = true;
    PrintWriter pwFastq = null;
    PrintWriter pwFasta = null;
    private int chunkNumber = -1;
    private int readCountInChunk = 0;
    private String currentFastqChunkFilename = null;
    private String currentFastaChunkFilename = null;
    private ArrayList<Integer> allReadLengths = new ArrayList();
    private ArrayList<Integer> writtenReadLengths = new ArrayList();
    private ArrayList<Integer> chunkReadLengths = new ArrayList();
    private int readsFilteredFromChunk = 0;
    private int readsFilteredTotal = 0;
    private FASTAQPairPendingList pendingPairList = null;
    private ReadFilterSample[] samples = new ReadFilterSample[101];
    private boolean keepRunning = true;

    public ReadFilterRunnable(MARTiEngineOptions o, FileWatcher f, FASTAQPairPendingList pfl) {
        this.options = o;
        this.fileWatcher = f;
        this.pendingPairList = pfl;
        for (int i = 0; i <= 100; ++i) {
            this.samples[i] = null;
        }
    }

    public void exitThread() {
        this.keepRunning = false;
    }

    private void processFile(String fastqPathname) {
        this.options.getLog().printlnLogAndScreen("Processing file (RFR) " + fastqPathname);
        int barcode = this.options.getBarcodeFromPath(fastqPathname);
        if (this.samples[barcode] == null) {
            this.samples[barcode] = new ReadFilterSample(this.options, this.fileWatcher, this.pendingPairList, barcode);
        }
        this.samples[barcode].processFile(fastqPathname);
    }

    private boolean checkValidExtension(String filename) {
        boolean valid = false;
        if (filename.toLowerCase().endsWith(".fastq") || filename.toLowerCase().endsWith(".fq")) {
            valid = true;
        } else if (filename.toLowerCase().endsWith(".fastq.gz") || filename.toLowerCase().endsWith(".fq.gz")) {
            String withoutGz = filename.substring(0, filename.length() - 3);
            File f = new File(withoutGz);
            if (!f.exists()) {
                valid = true;
                System.out.println("Processing " + filename + " because " + withoutGz + " doesn't exist");
            } else {
                System.out.println("Not processing " + filename + " because " + withoutGz + " exists");
            }
        }
        return valid;
    }

    private void processPendingFiles() {
        FileWatcherItem fwi = null;
        this.options.getLog().println("Checking for any final pending files...");
        do {
            String nextPathname;
            if ((fwi = this.fileWatcher.getPendingFile()) == null || !this.checkValidExtension(nextPathname = fwi.getPathname())) continue;
            this.processFile(nextPathname);
        } while (fwi != null);
    }

    @Override
    public void run() {
        while (!this.fileWatcher.timedOut() && !this.options.getStopFlag()) {
            String nextPathname;
            FileWatcherItem fwi = null;
            while (fwi == null && !this.fileWatcher.timedOut() && !this.options.getStopFlag()) {
                fwi = this.fileWatcher.getPendingFile();
                if (fwi != null) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(ReadFilterRunnable.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (fwi == null || !this.checkValidExtension(nextPathname = fwi.getPathname())) continue;
            this.processFile(nextPathname);
        }
        this.options.getLog().println("ReadFilterRunnable finalising");
        for (int i = 0; i < 100; ++i) {
            if (this.samples[i] == null) continue;
            this.samples[i].finalise();
        }
        this.processPendingFiles();
        this.options.getLog().println("ReadFilterRunnable thread exiting");
        this.outputStats();
    }

    private void outputStats() {
        for (int i = 0; i < 100; ++i) {
            if (this.samples[i] == null) continue;
            this.samples[i].outputStats();
        }
    }
}

