/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriterFactory;
import uk.ac.earlham.lcaparse.SimplifiedRank;
import uk.ac.earlham.lcaparse.Taxonomy;
import uk.ac.earlham.lcaparse.TaxonomyNode;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.MARTiResults;
import uk.ac.earlham.marti.core.TaxaAccumulationCounts;

public class TaxaAccumulation {
    private HashMap<Double, ArrayList<TaxaAccumulationCounts>> taxaCountsPerMinSupport = new HashMap();
    private MARTiEngineOptions options = null;
    private MARTiResults results = null;
    private SimplifiedRank simplifiedRank = new SimplifiedRank();
    private int bc = 0;
    private int nLeaves = 0;

    public TaxaAccumulation(MARTiEngineOptions o, MARTiResults r, int b) {
        this.options = o;
        this.results = r;
        this.bc = b;
    }

    private int exploreNode(TaxonomyNode n, int rank) {
        Taxonomy taxonomy = this.options.getReadClassifier().getTaxonomy();
        int markedChildren = 0;
        ArrayList<TaxonomyNode> children = n.getChildren();
        int childCount = 0;
        for (int i = 0; i < children.size(); ++i) {
            TaxonomyNode c = children.get(i);
            if (c.getLCASummed(this.bc) <= 0) continue;
            if (c.getSimplifiedRank() <= rank) {
                ++childCount;
                markedChildren += this.exploreNode(c, rank);
                continue;
            }
            this.options.getLog().println(4, "    Child " + taxonomy.getNameFromTaxonId(c.getId()) + " rank issue " + c.getRank() + " " + c.getSimplifiedRank());
        }
        if (markedChildren == 0 && n.getSimplifiedRank() != 0 && n.getSimplifiedRank() <= rank && n.getLCASummed(this.bc) > 0) {
            ++this.nLeaves;
            this.options.getLog().println(4, "    got node " + this.options.getReadClassifier().getTaxonomy().getNameFromTaxonId(n.getId()) + " summed " + n.getLCASummed(this.bc));
            ++markedChildren;
        }
        return markedChildren;
    }

    public void storeAccumulation(int fastaChunkNumber, int chunkNumberByOrderCompleted, int nReadsAnalysed, int mins, double minSupport) {
        ArrayList<Object> taxaCounts;
        Taxonomy taxonomy = this.options.getReadClassifier().getTaxonomy();
        long startTime = System.nanoTime();
        if (this.taxaCountsPerMinSupport.containsKey(minSupport)) {
            taxaCounts = this.taxaCountsPerMinSupport.get(minSupport);
        } else {
            taxaCounts = new ArrayList();
            this.taxaCountsPerMinSupport.put(minSupport, taxaCounts);
            this.options.getLog().println("Creating new taxaCounts for min support " + minSupport);
        }
        TaxaAccumulationCounts counts = new TaxaAccumulationCounts(fastaChunkNumber, chunkNumberByOrderCompleted, nReadsAnalysed, mins);
        taxaCounts.add(counts);
        for (int rank = 1; rank <= 10; ++rank) {
            this.options.getLog().println(4, "Exploring rank " + rank + " minSupport=" + minSupport + " fastaChunkNumber=" + fastaChunkNumber + " chunkNumberByOrderCompleted=" + chunkNumberByOrderCompleted);
            TaxonomyNode n = taxonomy.getNodeFromTaxonId(1L);
            this.nLeaves = 0;
            this.exploreNode(n, rank);
            counts.addCount(rank, this.nLeaves);
            this.options.getLog().println(4, "Rank " + rank + " leaves " + this.nLeaves);
        }
        long timeDiff = (System.nanoTime() - startTime) / 1000000L;
        this.options.getLog().println("Timing: Accumulation data stored in " + timeDiff + " ms");
    }

    public void writeJSON(double minSupport) {
        long startTime = System.nanoTime();
        if (this.taxaCountsPerMinSupport.containsKey(minSupport)) {
            ArrayList<TaxaAccumulationCounts> taxaCounts = this.taxaCountsPerMinSupport.get(minSupport);
            JsonObjectBuilder metaBuilder = Json.createObjectBuilder();
            metaBuilder.add("martiVersion", "v0.9.29");
            LocalDateTime date = LocalDateTime.now();
            String dateTimeString = date.truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).toString();
            metaBuilder.add("fileWritten", dateTimeString);
            JsonObjectBuilder accumulationBuilder = Json.createObjectBuilder();
            for (int rank = 1; rank <= 10; ++rank) {
                JsonObjectBuilder rankBuilder = Json.createObjectBuilder();
                JsonArrayBuilder readsArrayBuilder = Json.createArrayBuilder();
                JsonArrayBuilder timeArrayBuilder = Json.createArrayBuilder();
                for (int chunk = 0; chunk < taxaCounts.size(); ++chunk) {
                    TaxaAccumulationCounts tac = taxaCounts.get(chunk);
                    JsonArrayBuilder pairArrayBuilder = Json.createArrayBuilder();
                    pairArrayBuilder.add(tac.getReadsAnalysedCount());
                    pairArrayBuilder.add(tac.getCount(rank));
                    readsArrayBuilder.add(pairArrayBuilder);
                    pairArrayBuilder = Json.createArrayBuilder();
                    pairArrayBuilder.add(tac.getMinsSinceStart());
                    pairArrayBuilder.add(tac.getCount(rank));
                    timeArrayBuilder.add(pairArrayBuilder);
                }
                rankBuilder.add("reads", readsArrayBuilder);
                rankBuilder.add("time", timeArrayBuilder);
                accumulationBuilder.add(this.simplifiedRank.getSimplifiedRankString(rank), rankBuilder);
            }
            JsonObjectBuilder topLevelBuilder = Json.createObjectBuilder();
            topLevelBuilder.add("meta", metaBuilder);
            topLevelBuilder.add("accumulation", accumulationBuilder);
            JsonObject jsonObject = topLevelBuilder.build();
            int fileCount = taxaCounts.size();
            String jsonFilename = this.bc > 0 ? this.options.getLCAParseDirectory() + File.separator + "accumulation_barcode" + this.bc + "_ch" + fileCount + "_ms" + minSupport + ".json" : this.options.getLCAParseDirectory() + File.separator + "accumulation_ch" + fileCount + "_ms" + minSupport + ".json";
            String jsonFilenameFinal = this.options.getMARTiJSONDirectory(this.bc) + File.separator + "accumulation_ms" + minSupport + ".json";
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            JsonWriterFactory writerFactory = Json.createWriterFactory(config);
            try {
                StringWriter writer = new StringWriter();
                writerFactory.createWriter(writer).write(jsonObject);
                String jsonString = ((Object)writer).toString();
                PrintWriter pw = new PrintWriter(new FileWriter(jsonFilename));
                pw.write(jsonString);
                pw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            long timeDiff = (System.nanoTime() - startTime) / 1000000L;
            this.options.getLog().println("Timing: Accumulation data written in " + timeDiff + " ms");
            this.options.copyFile(jsonFilename, jsonFilenameFinal);
        } else {
            this.options.getLog().printlnLogAndScreen("Error: rarefaction data doesn't exist for min support " + minSupport);
        }
    }
}

